% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simHIMA.R
\name{simHIMA}
\alias{simHIMA}
\title{Simulation Data Generator for High-dimensional Mediation Analyais}
\usage{
simHIMA(n, p, alpha, beta, binaryOutcome = FALSE, seed)
}
\arguments{
\item{n}{an integer specifying sample size.}

\item{p}{an integer specifying the dimension of mediators.}

\item{alpha}{a numeric vector specifying the regression coefficients alpha (exposure --> mediators).}

\item{beta}{a numeric vector specifying the regression coefficients beta (mediators --> outcome).}

\item{binaryOutcome}{logical. Should the simulated outcome variable be binary?}

\item{seed}{an integer specifying a seed for random number generation.}
}
\description{
\code{simHIMA} is used to generate simulation data for high-dimensional mediation analysis.
}
\examples{
n <- 200  # sample size
p <- 200 # the dimension of covariates

# the regression coefficients alpha (exposure --> mediators)
alpha <- rep(0, p) 

# the regression coefficients beta (mediators --> outcome)
beta <- rep(0, p) 

# the first four markers are true mediators.
alpha[1:4] <- c(0.45,0.5,0.55,0.6)
beta[1:4] <- c(0.5,0.45,0.4,0.35)

alpha[7:8] <- 0.5
beta[5:6] <- 0.5

# Generate simulation data
simdat = simHIMA(n, p, alpha, beta, seed=1029) 

}
\seealso{
see \code{\link{hima}} to run HIMA.
}
