% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{children}
\alias{children}
\alias{build.children}
\alias{get.children.top.down}
\alias{get.children.bottom.up}
\title{Build children}
\usage{
build.children(g)

get.children.top.down(g, levels)

get.children.bottom.up(g, levels)
}
\arguments{
\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes}

\item{levels}{a list of character vectors. Each component represents a graph level and the elements of any 
component correspond to nodes. The level 0 coincides with the root node.}
}
\value{
\code{build.children} returns a named list of vectors. Each component corresponds to a node \eqn{x} of the graph and its 
vector is the set of its children

\code{get.children.top.down} returns a named list of character vectors. Each component corresponds to a node \eqn{x} 
of the graph (i.e. parent node) and its vector is the set of its children. The nodes are ordered from root (included) to leaves.

\code{get.children.bottom.up} returns a named list of character vectors. Each component corresponds to a node \eqn{x} 
of the graph (i.e. parent node) and its vector is the set of its children. The nodes are ordered from leaves (included) to root.
}
\description{
Compute the children for each node of a graph
}
\examples{
data(graph);
root <- root.node(g);
children <- build.children(g);
lev <- graph.levels(g, root=root);
children.tod <- get.children.top.down(g,lev);
children.bup <- get.children.bottom.up(g,lev);
}
\seealso{
\code{\link{graph.levels}}
}
