% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HEMDAG.1.0.0.R
\name{specific.annotation.matrix}
\alias{specific.annotation.matrix}
\title{HPO specific annotations matrix}
\usage{
specific.annotation.matrix(file = "gene2pheno.txt", genename = "TRUE")
}
\arguments{
\item{file}{text file representing the most specific associations gene-HPO term (\code{def: "gene2pheno.txt"}). 
The file must be written as sequence of rows. Each row represents a gene and all its
associations with abnormal phenotype tab separated, \cr \emph{e.g.: gene_1 <tab> phen1 <tab> ... phen_N}}

\item{genename}{boolean value: 
\itemize{
    \item TRUE (def.): the names of genes are \emph{gene symbol} (i.e. characters);
    \item FALSE: the names of gene are entrez \emph{gene ID} (i.e. integer numbers);
}}
}
\value{
the annotation matrix of the most specific annotations (0/1): rows are genes and columns are HPO terms.
Let's denote \eqn{M} the labels matrix. If \eqn{M[i,j]=1}, means that the gene \eqn{i} is annotated with the class \eqn{j}, otherwise \eqn{M[i,j]=0}.
}
\description{
Construct the labels matrix of the most specific HPO terms
}
\examples{
gene2pheno <- system.file("extdata/gene2pheno.txt", package="HEMDAG");
spec.ann <- specific.annotation.matrix(gene2pheno, genename=TRUE);
}
