\name{HDDA}
\alias{hdda}
\title{
High Dimensional Discriminant Analysis
}
\description{
HDDA is a model-based discriminant analysis method assuming each class of the dataset live in a proper Gaussian subspace which is much smaller than the original one, the hdda.learn function calculates the parameters of each subspace in order to predict  the class of new observation of this kind.
}
\usage{
hdda(data, cls, model='AkjBkQkDk', graph=FALSE, d="Cattell", 
	threshold=0.2, com_dim=NULL, show=TRUE, scaling=FALSE, 
	cv.dim=1:10, cv.threshold=c(.001,.005,.05,1:9*0.1), 
	cv.vfold=10, LOO=FALSE, noise.ctrl=1e-8)
}

\arguments{
  \item{data}{
A matrix or a data frame of observations, assuming the rows are the observations and the columns the variables. Note that NAs are not allowed.
}
  \item{cls}{
The vector of the class of each observations, its type can be numeric or string.
}
  \item{model}{
The models used with the HDDA method are the following: \dQuote{AkjBkQkDk}, \dQuote{AkBkQkDk}, \dQuote{ABkQkDk}, \dQuote{AkjBQkDk}, \dQuote{AkBQkDk}, \dQuote{ABQkDk}, \dQuote{AkjBkQkD}, \dQuote{AkBkQkD}, \dQuote{ABkQkD}, \dQuote{AkjBQkD}, \dQuote{AkBQkD}, \dQuote{ABQkD}, \dQuote{AjBQD}, \dQuote{ABQD} and \dQuote{all}. Note that the model names are not case sensitive. See details for more informations.
}
  \item{graph}{  It is for comparison sake only, when several estimations are run at the same time (either when using several models, or when using cross-validation to select the best dimension/threshold). If graph = TRUE, the plot of the results of all estimations is displayed. Default is FALSE.
}
  \item{d}{
  Either \dQuote{Cattell} (default), \dQuote{BIC} or \dQuote{CV}. See details for more information.
}
  \item{threshold}{
  A float stricly within 0 and 1. It is the threshold used in the Cattell's Scree-Test.
}
	\item{com_dim}{
	It is used only for common dimensions models. The user can give the common dimension he wants. If used, it must be an integer. Its default is set to NULL.
}
  \item{show}{
  Use show=FALSE to settle off the informations that may be printed.
}
  \item{scaling}{
  Logical: whether to scale the dataset (mean=0 and standard-deviation=1 for each variable) or not. By default the data is not scaled.
}
  \item{cv.dim}{
  A vector of integers. Only when d=\dQuote{CV}. Gives the dimensions for which the CV is to be done. Note that if some dimensions are greater than what it is possible to have, those are taken off.
}
  \item{cv.threshold}{
  A vector of floats strictly within 0 and 1. Only when d=\dQuote{CV}. Gives the thresholds for which the CV is to be done.
}
  \item{cv.vfold}{
  An integer. Only when d=\dQuote{CV}. It gives the number of different subsamples in which the dataset is split. If \dQuote{cv.vfold} is greater than the number of observations, then the program equalize them.
}
	\item{LOO}{
	If TRUE, it returns results (classes and posterior probabilities) for leave-one-out cross-validation.
}
	\item{noise.ctrl}{
	This parameter avoids to have a too low value of the 'noise' parameter b. It garantees that the dimension selection process do not select too many dimensions (which leads to a potential too low value of the noise parameter b). When selecting the intrinsic dimensions using Cattell's scree-test or BIC, the function doesn't use the eigenvalues inferior to noise.ctrl, so that the intrinsic dimensions selected can't be higher or equal to the order of these eigenvalues.
}
}

\value{
hdda returns an 'hdc' object; it's a list containing:
\item{ model }{The name of the model.}
\item{ k }{The number of classes.}
\item{ d }{The dimensions of each class.}
\item{ a }{The parameters of each class subspace.}
\item{ b }{The noise of each class subspace.}
\item{ mu }{The mean of each variable for each class.}
\item{ prop }{The proportion of each class.}
\item{ ev }{The eigen values of the var/covar matrix.}
\item{ Q }{The orthogonal matrix of orientation of each class.}
\item{ kname }{The name of each class.}
\item{ BIC }{The BIC value of the model used.}
\item{ scaling }{The centers and the standard deviation of the original dataset.}
}

\details{
Some information on the signification of the model names:
\describe{
	\item{Akj are the parameters of the classes subspaces:}{
		\itemize{
		\item{if Akj: each class has its parameters and there is one parameter for each dimension}
		\item{if Ak: the classes have different parameters but there is only one per class}
		\item{if Aj: all the classes have the same parameters for each dimension (it's a particular case with a common orientation matrix)}
		\item{if A: all classes have the same one parameter}
		}
	}

	\item{Bk are the noises of the classes subspaces:}{
		\itemize{
			\item{If Bk: each class has its proper noise}
			\item{if B:  all classes have the same noise}
		}
	}

	\item{Qk is the orientation matrix of each class:}{ 
		\itemize{
			\item{if Qk: all classes have its proper orientation matrix}
			\item{if Q: all classes have the same orientation matrix}
		}
	}
	
	\item{Dk is the intrinsic dimension of each class:}{ 
		\itemize{
			\item{if Dk: the dimensions are free and proper to each class}
			\item{if D: the dimension is common to all classes}
		}
	}
}
The model \dQuote{all} will compute all the models, give their BIC and keep the model with the highest BIC value.
Instead of writing the model names, they can also be specified using an integer.  1 represents the most general model (\dQuote{AkjBkQkDk}) while 14 is the most constrained (\dQuote{ABQD}), the others  number/name matching are given below. Note also that several models can be run at once, by using a vector of models (e.g. model = c("AKBKQKD","AKJBQKDK","AJBQD") is equivalent to model = c(8,4,13); to run the 6 first models, use model=1:6). If all the models are to be run, model="all" is faster than model=1:14. 
\tabular{lcclc}{
AkjBkQkDk \tab   1   \tab   \tab  AkjBkQkD \tab   7   \cr 
AkBkQkDk \tab   2   \tab \tab  AkBkQkD \tab   8   \cr   
ABkQkDk \tab   3   \tab  \tab ABkQkD \tab   9   \cr   
AkjBQkDk \tab   4   \tab  \tab  AkjBQkD \tab   10   \cr   
AkBQkDk \tab   5   \tab  \tab  AkBQkD \tab   11   \cr   
ABQkDk \tab   6   \tab  \tab  ABQkD \tab   12  \cr
AjBQD \tab 13 \tab  \tab ABQD \tab 14
}

The parameter d, is used to select the intrinsic dimensions of the subclasses. Here are his definictions:
		\itemize{
			\item{\dQuote{Cattell}:}{
				The Cattell's scree-test is used to gather the intrinsic dimension of each class. If the model is of common dimension (models 7 to 14), the scree-test is done on the covariance matrix of the whole dataset.
			}
			\item{\dQuote{BIC}:}{
				The intrinsic dimensions are selected with the BIC criterion. See Bouveyron \emph{et al.} (2010) for a discussion of this topic.
				For common dimension models, the procedure is done on the covariance matrix of the whole dataset.
			}
			\item{\dQuote{CV}:}{
				A V-fold cross-validation (CV) can be done in order to select the best threshold (for all models) or the best common dimensions (models 7 to 14).  
				The V-fold cross-validation is done for each dimension (respectively threshold) in the argument \dQuote{cv.dim} (resp. \dQuote{cv.threshold}), then the dimension (resp. threshold) that gives the best good classification rate is kept.  
				The dataset is split in \dQuote{cv.vfold} (default is 10) \emph{random} subsamples, then CV is done for each sample: each of them is used as validation data while the remaining data is used as training data. For sure, if \dQuote{cv.vfold} equals the number of observations, then this CV is equivalent to a leave-one-out.
			}
			\item{Note that "Cattell" (resp. "BIC") can be abreviated to "C" (resp. "B") and that this argument is not case sensitive.}
		}


}



\references{
Bouveyron, C. Girard, S. and Schmid, C. (2007) \dQuote{High Dimensional Discriminant Analysis}, \emph{Communications in Statistics: Theory and Methods}, vol. \bold{36} (14), pp. 2607--2623

Bouveyron, C. Celeux, G. and Girard, S. (2010) \dQuote{Intrinsic dimension estimation by maximum likelihood in probabilistic PCA}, Technical Report 440372, Universite Paris 1 Pantheon-Sorbonne

Berge, L. Bouveyron, C. and Girard, S. (2012) \dQuote{HDclassif: An R Package for Model-Based Clustering and Discriminant Analysis of High-Dimensional Data}, \emph{Journal of Statistical Software}, \bold{46}(6), 1--29, url: \href{http://www.jstatsoft.org/v46/i06/}{http://www.jstatsoft.org/v46/i06/}
}
\author{
Laurent Berge, Charles Bouveyron and Stephane Girard  
}
\seealso{
\code{\link{hddc}}, \code{\link{predict.hdc}}.
}
\examples{
#example 1:
data<-simuldata(1000, 1000, 50, K=5)
X <- data$X
clx <- data$clx
Y <- data$Y
cly <- data$cly
#we get the HDDA parameters:
prms1 <- hdda(X, clx)         

cl1 <- predict(prms1, Y, cly)
#the class vector of Y estimated with HDDA:
cl1$class                     

#another model is used:
prms1 <- hdda(X, clx, model=12)
#model=12 is equivalent to model="ABQkD"     
cl1 <- predict(prms1, Y, cly) 

#example 2:
data(wine)
a <- wine[,-1]
z <- wine[,1]
prms2 <- hdda(a, z, model='all', scaling=TRUE, d="B", graph=TRUE)
cl2 <- predict(prms2, a, z)

#getting the best dimension
#using a common dimension model
#we do LOO-CV using cv.vfold=nrow(a)
prms3 <- hdda(a, z, model="akjbkqkd", d="CV", cv.vfold=nrow(a), scaling=TRUE, graph=TRUE)

cl3 <- predict(prms3, a, z)

}
\keyword{ hdda }
\keyword{ predict }
\keyword{ classification }
