% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_tp_def.R
\name{output_tp}
\alias{output_tp}
\title{Prepares output for HDX-MS for the deuteration uptake or percent deuteration for the time points.}
\usage{
output_tp(
  filepath,
  replicates,
  states,
  times,
  seq_match = FALSE,
  csv = "NA",
  percent = FALSE
)
}
\arguments{
\item{filepath}{filepath to the input file. Input file is All_results table from HDX_Examiner, where all the fields are marked for export.}

\item{replicates}{number of replicates to be used in analysis. The function takes number of replicates up to specified number. If no argument provided number maximal common number of replicates it used.}

\item{states}{function allows to choose what states should be used for analysis. Default all states are used.}

\item{times}{lists the deuteration times to be used in analysis. Default all states used.}

\item{seq_match}{Flag allows to choose if the peptide sequences should be matched between states. seq_match=FALSE signifies no sequence matching, seq_match=T states that the sequences are matched between the sets.}

\item{csv}{Flag allowing saving the output as csv. With default csv="NA", data is not saved. If csv output is desided, provide output name.}

\item{percent}{Flag allowing to choose output as deteuration uptake (FALSE) or percent deuteration (TRUE). Default deuteration uptake.}
}
\value{
data frame with reorganized data where in columns is the deuteration uptake for Protein States.
}
\description{
Returns a data frame organized for additional analysis.
In columns are deuteration uptake or percent deuteration data for the given protein states.
Function allows for writing csv with data, matching sequences of peptide.
Protein.States, Deut.times, or number of replicates can be specified.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(filepath=file_nm) ###all default parameters used


# all possible flags listed & percent deuteration output,
# with sequences matching for protein states.

a<-output_tp(filepath=file_nm, replicates=3, states=c("bound", "Unbound"),
times=c("3.00s", "72000.00s"), seq_match=TRUE, csv="NA", percent=TRUE)
}
