% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitScan.R
\name{InitScan}
\alias{InitScan}
\title{Initalization of the scan procedures by creating the matrix of potential clusters}
\usage{
InitScan(
  mini_post,
  maxi_post,
  type_minimaxi_post,
  sites_areas,
  sites_coord,
  system,
  mini,
  maxi,
  type_minimaxi
)
}
\arguments{
\item{mini_post}{numeric. A minimum to filter the significant clusters a posteriori (see type_minimaxi_post). The default NULL is for no filtering with a a posteriori minimum.}

\item{maxi_post}{numeric. A maximum to filter the significant clusters a posteriori (see type_minimaxi_post). The default NULL is for no filtering with a a posteriori maximum.}

\item{type_minimaxi_post}{character. Type of minimum and maximum a posteriori: by default "sites/indiv": the mini_post and maxi_post are on the number of sites or individuals in the significant clusters. Other possible values are "area": the minimum and maximum area of the clusters, or "radius": the minimum and maximum radius.}

\item{sites_areas}{numeric vector. Areas of the sites. It must contain the same number of elements than the rows of sites_coord. If the data is on individuals and not on sites, there can be duplicated values. By default: NULL}

\item{sites_coord}{numeric matrix. Coordinates of the sites (or the individuals, in that case there can be many individuals with the same coordinates).}

\item{system}{character. System in which the coordinates are expressed: "Euclidean" or "WGS84".}

\item{mini}{integer. A minimum for the clusters (see type_minimaxi). Changing the default value may bias the inference.}

\item{maxi}{integer. A Maximum for the clusters (see type_minimaxi). Changing the default value may bias the inference.}

\item{type_minimaxi}{character. Type of minimum and maximum: by default "sites/indiv": the mini and maxi are on the number of sites or individuals in the potential clusters. Other possible values are "area": the minimum and maximum area of the clusters, or "radius": the minimum and maximum radius.}
}
\value{
The list of the following elements:
\itemize{
\item filtering_post: logical, is there an a posteriori filtering?
\item matrix_clusters: the matrix of potential clusters
\item centres: the coordinates of the centres of each potential cluster
\item radius: the radius of the potential clusters in km if system = WGS84 or in the user units
\item areas: the areas of the potential clusters (in the same units as sites_areas).
\item sites_coord: coordinates of the sites
\item system: system in which the coordinates are expressed
\item mini_post: a minimum to filter the significant clusters a posteriori
\item maxi_post: a maximum to filter the significant clusters a posteriori
\item type_minimaxi_post: type of minimum and maximum a posteriori
}
}
\description{
This function initializes the scan procedures by creating the matrix of potential clusters.
}
