% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDCurves.R
\name{emp_deriv}
\alias{emp_deriv}
\title{Estimate of empirical derivative based on sequence of quotient differences.}
\usage{
emp_deriv(y, t, D, u, ztype = 0)
}
\arguments{
\item{y}{numeric vector (response variable).}

\item{t}{numeric vector (time variable).}

\item{D}{integer indicating the bin width when estimating empirical derivatives}

\item{u}{real indicating the bandwidth with regards to smoothing when estimating empirical derivatives.}

\item{ztype}{integer indicating which sequence of empirical derivatives will be employed.  (\code{0} indicates that which is parameterized by D and u while \code{1} indicates that which is parametrized by u)}

}
\value{

The vector which as the same length as the input variable "y" that contains empirical derivative estimates for each entry of "y".

}
\description{
\code{emp_deriv} Provides an estimate of an empirical derivative curve using one of the two sequence of quotient differences detailed in Page, Rodriguez-Alvarez, Lee (2020).
}

\references{
  Page, G. L.; Rodriguez-Alvarez, M. X.; Lee, DJ; (2020)  ``Bayesian Hierarchical Modeling of Growth Curve Derivatives via Sequences of Quotient Differences'' to appear
}
\examples{

  # Our R-package
  library(HDCurves)

  data(growth)

  y <- growth$hgtm[,1]
  t <- growth$age

  fprime <- emp_deriv(y=y, t=t, D=10, u=1, ztype=0)

  plot(t,y, type="b")
  plot(t, fprime, type="b")

}

