% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SnowGlacier_HBV}
\alias{SnowGlacier_HBV}
\title{Snow and ice-melt models}
\usage{
SnowGlacier_HBV(
       model,
       inputData,
       initCond,
       param
)
}
\arguments{
\item{model}{numeric indicating which model you will use:
\itemize{
  \item 1: temperature index model.
  \item 2: temperature index model with a variable snow cover area as input data
  (as in the Snowmelt Runoff Model - SRM).
  \item 3: temperature index model with a variable glacier area as input data.
}}

\item{inputData}{numeric matrix being columns the input variables. As in the whole
package functions, \code{NA_real_}  values are forbidden. When speaking about model
options we refer to the \strong{\code{model}} argument.

\strong{Model 1:} \itemize{
\item \code{column_1}: air temperature series \eqn{[°C/\Delta t]}.
\item \code{column_2}: precipitation series \eqn{[mm/\Delta t]}.
}

\strong{Model 2:} \itemize{
\item \code{column_1}: air temperature \eqn{[°C/\Delta t]}.
\item \code{column_2}: precipitation \eqn{[mm/\Delta t]}.
\item \code{column_3}: snow cover area. Values between [0 ; 1] \eqn{[-]}.
}

\strong{Model 3:} \itemize{
\item \code{column_1}: air temperature  \eqn{[°C/\Delta t]}.
\item \code{column_2}: precipitation  \eqn{[mm/\Delta t]}.
\item \code{column_3}: glacier cover area. This area values are relative to the
total surface area of the basin \eqn{[-]}.
}}

\item{initCond}{numeric vector with the following values.
\itemize{
\item \code{SWE0}: initial snow water equivalent \eqn{[mm]}.
\item numeric integer indicating the surface type. \emph{1}: clean ice; \emph{2}: soil;
\emph{3}: debris-covered ice.
\item area of the glacier(s) (in the elevation band) relative to the basin; e.g.: 0.1 \eqn{[-]}.
This option is required in \emph{Model 1} and \emph{Model 2} when surface is a glacier.
}}

\item{param}{numeric vector with the following values:
\enumerate{
\item \code{SFCF}: snowfall correction factor \eqn{[-]}.
\item \code{Tr}: solid and liquid precipitation threshold temperature \eqn{[ºC]}.
\item \code{Tt}: melt temperature \eqn{[ºC]}.
\item \code{fm}: snowmelt factor \eqn{[mm/°C.\Delta t]}.
\item \code{fi}: icemelt factor \eqn{[mm/°C.\Delta t]}.
\item \code{fic}: debris-covered ice-melt factor \eqn{[mm/°C.\Delta t]}.
}}
}
\value{
Numeric matrix with the following columns:

\strong{Model 1}

** if surface is soil,
\enumerate{
  \item \code{Prain}: precip. as rainfall.
  \item \code{Psnow}: precip. as snowfall.
  \item \code{SWE}: snow water equivalent.
  \item \code{Msnow}: melted snow.
  \item \code{Total}: \code{Prain} + \code{Msnow}.
}

 ** if surface is ice,
 \enumerate{
   \item \code{Prain}: precip. as rainfall.
   \item \code{Psnow}: precip. as snowfall.
   \item \code{SWE}: snow water equivalent.
   \item \code{Msnow}: melted snow.
   \item \code{Mice}: melted ice.
   \item \code{Mtot}: \code{Msnow} + \code{Mice}.
   \item \code{Cum}: \code{Psnow} - \code{Mtot}.
   \item \code{Total}: \code{Prain} + \code{Mtot}.
   \item \code{TotScal}: \code{Total} * initCond[3].
 }

\strong{Model 2}

** if surface is soil,
\enumerate{
   \item \code{Prain}: precip. as rainfall.
   \item \code{Psnow}: precip. as snowfall.
   \item \code{SWE}: snow water equivalent.
   \item \code{Msnow}: melted snow.
   \item \code{Total}: \code{Prain} + \code{Msnow}.
   \item \code{TotScal}: \code{Msnow} * \code{SCA} + \code{Prain}.
 }

** if surface is ice -> as in \emph{Model 1}

\strong{Model 3}

** if surface is soil -> as in \emph{Model 1}

** if surface is ice,
 \enumerate{
   \item \code{Prain}: precip. as rainfall.
   \item \code{Psnow}: precip. as snowfall.
   \item \code{SWE}: snow water equivalent.
   \item \code{Msnow}: melted snow.
   \item \code{Mice}: melted ice.
   \item \code{Mtot}: \code{Msnow} + \code{Mice}.
   \item \code{Cum}: \code{Psnow} - \code{Mtot}.
   \item \code{Total}: \code{Prain} + \code{Mtot}.
   \item \code{TotScal}: \code{Total} *  inputData[i, 3].
 }
}
\description{
Allows you to simulate snow accumulation and melting processes
using a temperature index approach. The function also incorporates options
for clean and debris covered glacier surface mass balance simulations.
}
\examples{
# The following is a toy example. I strongly recommend to see
# the package vignettes in order to improve your skills on HBV.IANIGLA

## Debris-covered ice
ObsTemp   <- sin(x = seq(0, 10*pi, 0.1))
ObsPrecip <- runif(n = 315, max = 50, min = 0)
ObsGCA    <- seq(1, 0.8, -0.2/314)

## Fine debris covered layer assumed. Note that the ice-melt factor is cumpulsory but harmless.
DebrisCovGlac <- SnowGlacier_HBV(model = 3,
                                 inputData = cbind(ObsTemp, ObsPrecip, ObsGCA),
                                 initCond = c(10, 3, 1),
                                 param = c(1, 1, 0, 3, 1, 6))

}
\references{
Bergström, S., Lindström, G., 2015. Interpretation of runoff processes in hydrological
modelling—experience from the HBV approach. Hydrol. Process. 29, 3535–3545.
https://doi.org/10.1002/hyp.10510

DeWalle, D. R., & Rango, A. (2008). Principles of Snow Hydrology.

Parajka, J., Merz, R., Blöschl, G., 2007. Uncertainty and multiple objective calibration
in regional water balance modelling: case study in 320 Austrian catchments.
Hydrol. Process. 21, 435–446. https://doi.org/10.1002/hyp.6253

Seibert, J., Vis, M.J.P., 2012. Teaching hydrological modeling with a user-friendly
catchment-runoff-model software package. Hydrol Earth Syst Sci 16, 3315–3325.
https://doi.org/10.5194/hess-16-3315-2012
}
