% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vecchia_Linv_grouped}
\alias{vecchia_Linv_grouped}
\title{Inverse Cholesky factor implied by Vecchia's approximation}
\usage{
vecchia_Linv_grouped(covparms, covfun_name, locs, NNlist)
}
\arguments{
\item{covparms}{A vector of covariance parameters appropriate
for the specified covariance function}

\item{covfun_name}{One of "matern_isotropic", "matern_space_time", "matern_sphere", 
or "matern_sphere_time".
"matern_isotropic" and "matern_sphere" have four covariance parameters, 
(variance, range, smoothness, nugget), while "matern_space_time" and 
"matern_sphere_time" have five,
(variance, spatial range, temporal range, smoothness, nugget). 
For more details, see the documentation 
for each of the covariance functions by typing, for example, ?matern_isotropic
or ?matern_sphere_time.}

\item{locs}{matrix of locations. Row \code{i} of locs specifies the location
of element \code{i} of \code{y}, and so the length of \code{y} should equal
the number of rows of \code{locs}.}

\item{NNlist}{A list with grouped neighbor information. 
Usually the output from \code{group_obs(NNarray)}.}
}
\value{
vector containing entries of grouped approximation to inverse Cholesky
}
\description{
This function returns the entries of the sparse approximation to 
the Cholesky factor implied by Vecchia's (1988) approximation to the Gaussian
loglikelihood. The approximation modifies the ordered conditional
specification of the joint density; rather than each term in the product
conditioning on all previous observations, each term conditions on
a small subset of previous observations.
}
\examples{
n1 <- 40
n2 <- 40
n <- n1*n2
locs <- as.matrix( expand.grid( (1:n1)/n1, (1:n2)/n2 ) )
covparms <- c(2, 0.2, 0.75, 0)
ord <- order_maxmin(locs)
NNarray <- find_ordered_nn(locs,20)
Linv <- vecchia_Linv( covparms, "matern_isotropic", locs, NNarray )
}
