% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupNumeric.R
\name{GroupNumeric}
\alias{GroupNumeric}
\title{Group a numerical variable into an n-level factor}
\usage{
GroupNumeric(x, n = NULL, groupNames = NULL, orderedFactor = FALSE,
  style = "quantile", ...)
}
\arguments{
\item{x}{Numeric vector to be grouped.}

\item{n}{Integer number of groups; if NULL (the
default), the number of groups will be inferred
from the groupNames parameter.}

\item{groupNames}{Character vector of names for
the levels of the factor variable created; if
NULL (the default), the default names from R's
cut function will be used.}

\item{orderedFactor}{Logical, specifying whether
the factor returned is ordered or not; default
is FALSE.}

\item{style}{Character string, passed to the
classIntervals function from the classInt
package as its style parameter (see help
file for the classInterval function for
details); default is "quantile".}

\item{\dots}{Optional parameters passed to the
classIntervals function from the classInt package.}
}
\value{
Factor variable with n distinct levels,
named according to groupNames (if specified).
}
\description{
\code{GroupNumeric} converts a numerical variable x
into a factor variable with n groups for categorical
association analysis.
}
\details{
This function uses the classIntervals function from
the classInt package to compute the breakpoints
that define the groups.  The style parameter is
passed to the classIntervals function to specify
the grouping method.  Note that some methods may
return a different number of groups than that
requested via the n parameter.  If groupNames is
specified consistently with n, this different
number of returned groups will cause an error.
The recommended approach in this case is to either
change the style parameter or to re-run without
groupNames specified.
}
\author{
Ron Pearson
}

