% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoMiner.R
\name{RCPD}
\alias{RCPD}
\title{RCPD}
\usage{
RCPD(GOGOA3, tablePop, geneList, nrand, ontology, hyper, subd, opt)
}
\arguments{
\item{GOGOA3}{return value of subsetGOGOA()}

\item{tablePop}{return value of GOtable3()}

\item{geneList}{character vector lisgt of genes to randomize}

\item{nrand}{integer number of randomizations}

\item{ontology}{c("molecular_function","cellular_component","biological_process")}

\item{hyper}{return value of GOhypergeometric3() from real (nonrandom) data}

\item{subd}{character string pathname for directory containing sink.txt}

\item{opt}{integer 0:1 parameter used to select randomization method}
}
\value{
returns a histogram of log10(p)
}
\description{
prepare a cpd of p values from randomized gene sets
}
\details{
the cpd of the randomizations is to be used for estimating
the false discovery rate (FDR) of the real sampled genes
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# you can generate it using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO/tree/main/databases
load("/Users/barryzeeberg/personal/GODB_RDATA/goa_human/GOGOA3_goa_human.RData")
rcpd<-RCPD(GOGOA3,x_tablePop31,10,3,"biological_process",x_hyper1,tempdir(),0)
}

}
