% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptionStats.R
\name{describeProp}
\alias{describeProp}
\title{A function that returns a description proportion that contains
the number and the percentage}
\usage{
describeProp(
  x,
  html = TRUE,
  digits = 1,
  digits.nonzero = NA,
  number_first = TRUE,
  useNA = c("ifany", "no", "always"),
  useNA.digits = digits,
  default_ref,
  percentage_sign = TRUE,
  language = "en",
  ...
)
}
\arguments{
\item{x}{The variable that you want the statistics for}

\item{html}{If HTML compatible output should be used. If \code{FALSE}
it outputs LaTeX formatting}

\item{digits}{The number of decimals used}

\item{digits.nonzero}{The number of decimals used for values that are close to zero}

\item{number_first}{If the number should be given or if the percentage
should be presented first. The second is encapsulated in parentheses ().
This is only used together with the useNA variable.}

\item{useNA}{This indicates if missing should be added as a separate
row below all other. See \code{\link[base]{table}} for \code{useNA}-options.
\emph{Note:} defaults to ifany and not "no" as \code{\link[base]{table}} does.}

\item{useNA.digits}{The number of digits to use for the
missing percentage, defaults to the overall \code{digits}.}

\item{default_ref}{The default reference, either first,
the level name or a number within the levels. If left out
it defaults to the first value.}

\item{percentage_sign}{If you want to suppress the percentage sign you
can set this variable to FALSE. You can also choose something else that
the default \% if you so wish by setting this variable. Note, this is
only used when combined with the missing information.}

\item{language}{The ISO-639-1 two-letter code for the language of
interest. Currently only english is distinguished from the ISO
format using a ',' as the separator in the \code{\link{txtInt}}
function.}

\item{...}{Passed on to \code{\link{describeFactors}}}
}
\value{
\code{string} A string formatted for either LaTeX or HTML
}
\description{
A function that returns a description proportion that contains
the number and the percentage
}
\examples{
describeProp(factor(sample(50, x=c("A","B", NA), replace=TRUE)))

}
\seealso{
Other descriptive functions: 
\code{\link{describeFactors}()},
\code{\link{describeMean}()},
\code{\link{describeMedian}()},
\code{\link{getDescriptionStatsBy}()},
\code{\link{getPvalWilcox}()}
}
\concept{descriptive functions}
