% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/descriptionStats.R
\name{describeFactors}
\alias{describeFactors}
\title{Describes factor variables}
\usage{
describeFactors(x, html = TRUE, digits = 1, number_first = TRUE,
  useNA = c("ifany", "no", "always"), useNA.digits = digits,
  horizontal_proportions, percentage_sign = TRUE, language = "en", ...)
}
\arguments{
  \item{x}{The variable that you want the statistics for}

  \item{html}{If HTML compatible output should be used. If
  \code{FALSE} it outputs LaTeX formatting}

  \item{digits}{The number of decimals used}

  \item{number_first}{If the number should be given or if
  the percentage should be presented first. The second is
  encapsulated in parentheses (). This is only used
  together with the useNA variable.}

  \item{useNA}{This indicates if missing should be added as
  a separate row below all other. See
  \code{\link[base]{table}} for \code{useNA}-options.
  \emph{Note:} defaults to ifany and not "no" as
  \code{\link[base]{table}} does.}

  \item{useNA.digits}{The number of digits to use for the
  missing percentage, defaults to the overall
  \code{digits}.}

  \item{horizontal_proportions}{Is only active if useNA
  since this is the only case of a proportion among
  continuous variables. This is default NULL and indicates
  that the proportions are to be interpreted in a vertical
  manner. If we want the data to be horizontal, i.e. the
  total should be shown and then how these differ in the
  different groups then supply the function with the total
  number in each group, i.e. if done in a by manner as in
  \code{\link{getDescriptionStatsBy}} it needs to provide
  the number before the by() command.}

  \item{percentage_sign}{If you want to suppress the
  percentage sign you can set this variable to FALSE. You
  can also choose something else that the default \% if you
  so wish by setting this variable. Note, this is only used
  when combined with the missing information.}

  \item{language}{The ISO-639-1 two-letter code for the
  language of interest. Currently only english is
  distinguished from the ISO format using a ',' as the
  separator in the \code{\link{txtInt}} function.}

  \item{...}{Passed on to \code{\link{txtInt}}}
}
\value{
A string formatted for printing either latex by HTML
}
\description{
A function that returns a description proportion in a
factir that contains the number of times a variable and the
percentage
}
\examples{
set.seed(1)
describeFactors(sample(50, x=c("A","B", "C"), replace=TRUE))

n <- 500
my_var <- factor(sample(size=n, x=c("A","B", "C", NA), replace=TRUE))
my_exp <- rbinom(n=n, size=1, prob=0.2)
total <- table(my_var, useNA="ifany")
by(my_var,
   INDICES=my_exp,
   FUN=describeFactors,
   useNA="ifany",
   horizontal_proportions = total)
}
\seealso{
\code{\link{getDescriptionStatsBy}}

Other description functions: \code{\link{describeMean}};
\code{\link{describeMedian}}; \code{\link{describeProp}}
}

