% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_phases_relat.R
\name{prob.phases.relat}
\alias{prob.phases.relat}
\title{R function to calculate the Posterior Probability for different chronological relations between
two Bayesian radiocarbon phases}
\usage{
prob.phases.relat(
  data = NULL,
  sAoldersB = NULL,
  sAoldereB = NULL,
  eAoldersB = NULL,
  eAoldereB = NULL,
  sBoldersA = NULL,
  sBoldereA = NULL,
  eBoldersA = NULL,
  eBoldereA = NULL,
  sort = FALSE
)
}
\arguments{
\item{data}{Matrix containing the posterior probability of the chronological relation between
the Starting and Ending boundaries of two independent phases, as returned by the OxCal's
'Order' query (see Details).}

\item{sAoldersB}{Probability of startA being older than startB.}

\item{sAoldereB}{Probability of startA being older than endB.}

\item{eAoldersB}{Probability of endA being older than startB.}

\item{eAoldereB}{Probability of endA being older than endB.}

\item{sBoldersA}{Probability of startB being older than startA.}

\item{sBoldereA}{Probability of startB being older than endA.}

\item{eBoldersA}{Probability of endB being older than startA.}

\item{eBoldereA}{Probability of endB being older than endA.}

\item{sort}{logical which takes TRUE or FALSE (default) if the user does or does not want the
returned posterior probabilities sorted in descending order.}
}
\description{
The function allows to calculate the posterior probability for different chronological relations
between two phases defined via Bayesian radiocarbon modeling. For the results to make sense, the
phases have to be defined as independent if one wishes to assess what is the posterior
probability for different relative chronological relations between them.\cr
}
\details{
The rationale for this approach is made clear in an article by Buck et al 1992
(https://doi.org/10.1016/0305-4403(92)90025-X), and it runs as follows: "if we do not make any
assumption about the relationship between the phases, can we test how likely they are to be in
any given order"?\cr

Data can be fed into the function in two ways:\cr

-the function takes as input the table provided
by the 'OxCal' program  as result of the 'Order' query.\cr Once the table as been saved from 'OxCal'
in .csv format, you have to feed it in R. A .csv file can be imported into R using (for
instance): \eqn{mydata <- read.table(file.choose(), header=TRUE, sep=",", dec=".", as.is=T)};\cr

be sure to insert the phases' parameters (i.e., the starting and ending boundaries of the two
phases) in the OxCal's Order query in the following order: StartA, EndA, StartB, EndB; that is,
first the start and end of your first phase, then the start and end of the second one; you can
give any name to your phases, as long as the order is like the one described.\cr

-alternatively, 8 relevant parameters (which can be read off from the Oxcal's Order query output)
can be manually fed into the function (see the Arguments section above).\cr

Given two phases A and B, the function allows to calculate the posterior probability for:\cr

-A
being within B\cr -B being within A\cr -A starting earlier but overlapping with B\cr -B starting
earlier but overlapping with A\cr -A being entirely before B\cr -B being entirely before A\cr -sA
being within B\cr -eA being within B\cr -sB being within A\cr -eB being within A\cr where 's' and
'e' refer to the starting and ending boundaries of a phase.\cr

The function will return a table and
a dot plot.\cr

Thanks are due to Dr. Andrew Millard (Durham University) for the help provided in
working out the operations on probabilities.
}
\examples{
#load a toy dataset
data(phases)

 #calculate the Posterior Probability for the chronological relation between two phases,
 # stores the results in the 'res' object, and produce a dot chart.
res <- prob.phases.relat(phases)

# same as above, but manually feeding relevant parameters
res <- prob.phases.relat(data=NULL, sAoldersB=0.613, sAoldereB=1, eAoldersB=0.0010,
eAoldereB=0.666, sBoldersA= 0.386, sBoldereA=0.999, eBoldersA=0.000039, eBoldereA=0.3334)

}
\keyword{prob.phases.relat}
