% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsInPolygons.R
\name{pointsInPolygons}
\alias{pointsInPolygons}
\title{R function to test points-in-polygons relationship}
\usage{
pointsInPolygons(point.feat, polyg.feat, studyplot = NULL, scenario,
  buffer = 0, cex.text = 0.7)
}
\arguments{
\item{point.feat}{Feature (of point type; SpatialPointsDataFrame class) whose spatial association
with the polygons has to be assessed.}

\item{polyg.feat}{Feature (polygon type; SpatialPolygonsDataFrame) in relation to which the
spatial association of the points has to be assessed.}

\item{studyplot}{Shapefile (of polygon type; SpatialPolygonsDataFrame) representing the study
area; if not provided, the study area is internally worked out as the bounding polygon based on
the union the convex hulls of the point and of the polygon feature.}

\item{scenario}{Select one of the two types of analysis available ("a" or "b").}

\item{buffer}{Add a buffer to the convex hull of the study area (0 by default); the unit depends
upon the units of the input data.}

\item{cex.text}{Modify the size of the labels in the plot produced by the 'scenario b' option.}
}
\value{
For scenario "a" the function produces a plot of the points and polygons (plus the study
area), and relevant information are reported at the bottom of the chart itself.\cr

A list is also
returned, containing what follows:\cr -$Polygons' area;\cr -$Study area's area;\cr -$Total # of
points;\cr -$Observed # of points in polygons;\cr -$Expected # of points in polygons;\cr -$Exact
probability of observed count within polygons;\cr -$Probability of <= observed count within
polygons;\cr -$Probability of >= observed count within polygons.

For scenario "b" the function returns a plot showing the polygons plus the dots; in each polygon
the observed and expected counts are reported, and the p-value of the observed count is
indicated.\cr

A matrix is also returned, containing what follows:\cr -polygons' area;\cr
-percentage area (size of each polygon relative to sum of the polygons' area; it corresponds to
the probability (p) fed into the binomial distribution function);\cr -observed number of
points;\cr -expected number of points;\cr -probability of observed counts;\cr -probability of
observed counts <= than expected;\cr -probability of observed counts >= than expected.\cr
}
\description{
The function allows to test:\cr -scenario a:\cr if there is a significant spatial association
between a set of points and a set of polygons, in terms of points falling within the polygons.
In other
words, it aims at testing whether a set of points falls inside a set of polygons more often than
would be expected by chance. The basic assumption is that the polygons are completely contained
within the study plot. If the shapefile (of polygon type) representing the study plot is not
provided, the calculations use the bounding polygon based on the union the convex hulls of the
point and of the polygon feature.\cr -scenario b:\cr if the distribution of points within a set of
polygons totally covering the study area can be considered random, or if the observed points count
for each polygon is larger or smaller than expected. P values are also reported.\cr
}
\details{
The computations relative to scenario "a" are based on the 'dbinom() and 'pbinom()' functions. The
probability of observed count within polygons is \eqn{dbinom(x, size=n.of.points, prob=p)}, where
'x'
is the observed number of points within polygons, 'n.of.points' is the total number of points, and
'p' is the probability that a single point will be found within a polygon, which is equal to the
ratio between the area of the polygons and the total area of the study plot. The probability that
x or fewer points will be found within the polygons is \eqn{pbinom(x, size=n.of.points, prob=p)}.

The calculations relative to the scenario "b" are again based on the binomial distribution: the
probability of the observed counts is \eqn{dbinom(x, size=n.of.points, prob=p)}, where 'x' is the
observed number of points within a given polygon, 'n.of.points' is the total number of points, and
'p' is equal to the size of each polygon relative to sum of the polygons' area. The probability
that x or fewer points will be found within a given polygon is \eqn{pbinom(x, size=n.of.points,
prob=p)}.\cr
}
\examples{
data(points)
data(polygons)

result <- pointsInPolygons(points, polygons, scenario="a")

data(events)
data(thiessenpolyg)

result <- pointsInPolygons(events, thiessenpolyg, scenario="b")

}
\seealso{
\code{\link{pointsToPointsTess}} ,
 \code{\link[stats]{dbinom}} , \code{\link[stats]{pbinom}}
}
\keyword{pointsInPolygons}
