% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_reactions.R
\name{compile_reactions}
\alias{compile_reactions}
\title{Precompile the reactions}
\usage{
compile_reactions(reactions, state_ids, params, buffer_ids = NULL,
  hardcode_params = FALSE, write_rcpp = NA_character_, fun_by = 100L)
}
\arguments{
\item{reactions}{'\link{reaction}' A list of multiple \code{\link[=reaction]{reaction()}} objects.}

\item{state_ids}{\code{[character]} The names of the states in the correct order.}

\item{params}{\code{[named numeric]} Constants that are used in the propensity functions.}

\item{buffer_ids}{\code{[character]} The order of any buffer calculations that are made as part of the propensity functions.}

\item{hardcode_params}{\code{[logical]} Whether or not to hardcode the values of \code{params} in the compilation of the propensity functions.
Setting this to \code{TRUE} will result in a minor sacrifice in accuracy for a minor increase in performance.}

\item{write_rcpp}{\code{[character]} If not \code{NULL}, then the source code of the propensity functions will be written
to this file location before compilation.}

\item{fun_by}{\code{[integer]} Combine this number of propensity functions into one function.}
}
\value{
A list of objects solely to be used by \code{\link[=ssa]{ssa()}}.
\itemize{
\item \code{x[["state_change"]]}: A sparse matrix of reaction effects.
\item \code{x[["reaction_ids"]]}: The names of the reactions.
\item \code{x[["buffer_ids"]]}: A set of buffer variables found in the propensity functions.
\item \code{x[["buffer_size"]]}: The minimum size of the buffer required.
\item \code{x[["functions_pointer"]]}: A pointer to the compiled propensity functions.
\item \code{x[["num_functions"]]}: The compiled propensity functions are split up into multiple batches of functions.
\item \code{x[["hardcode_params"]]}: Whether the parameters were hard coded into the source code.`
}
}
\description{
By precompiling the reactions, you can run multiple SSA simulations repeatedly
without having to recompile the reactions every time.
}
