% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportBed.R
\name{exportBed}
\alias{exportBed}
\title{Exporting a Bed File.}
\usage{
exportBed(x, file = NULL, header = FALSE)
}
\arguments{
\item{x}{data.frame}

\item{file}{Character, specifies filename/path}

\item{header}{Logical, shall a header be written}
}
\value{
A bed file
}
\description{
This function exports a standard bed file.
}
\details{
This function exports a data.frame to a standard bed file. If no file name is given, the variable name will be used instead.
}
\examples{
novelBed <- data.frame(Chr=c(11,18,3),
                      Start=c(72554673, 62550696, 18148822),
                      End=c(72555273, 62551296, 18149422),
                      Gene=c("LOC1", "LOC2", "LOC3"))

# Create a temporary file to where the output of the function is stored
myfile <- file.path(tempdir(), "myLocs.bed")

exportBed(novelBed, file=myfile)
exportBed(novelBed, file=myfile, header=TRUE)

}
\author{
Daniel Fischer
}
