% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcm.R
\name{comp.resids}
\alias{comp.resids}
\title{Wrapper function to computing residuals from a regression method}
\usage{
comp.resids(V, Z, regr.pars, regr.method)
}
\arguments{
\item{V}{A (nxp)-dimensional matrix (or data frame) with n observations of p variables.}

\item{Z}{A (nxp)-dimensional matrix (or data frame) with n observations of p variables.}

\item{regr.pars}{Some regression methods require a list of additional options.}

\item{regr.method}{A string indicating the regression method that is used. Currently implemented are 
"gam", "xgboost", "kernel.ridge", "nystrom". The regression is performed only if 
not both resid.XonZ and resid.YonZ are set to NULL.}
}
\value{
Vector of residuals.
}
\description{
This function is used for the GCM test. 
Other methods can be added.
}
\examples{
set.seed(1)
n <- 250 
Z <- 4*rnorm(n) 
X <- 2*sin(Z) + rnorm(n)
res <- comp.resids(X, Z, regr.pars = list(), regr.method = "gam")

}
\references{
Please cite the following paper.
Rajen D. Shah, Jonas Peters: 
"The Hardness of Conditional Independence Testing and the Generalised Covariance Measure"
https://arxiv.org/abs/1804.07203
}
