% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.mtd_probit.R
\name{multi.mtd_probit}
\alias{multi.mtd_probit}
\title{Estimation of Multivariate Markov Chains: MTD - Probit Model}
\usage{
multi.mtd_probit(y, initial, nummethod = "bfgs")
}
\arguments{
\item{y}{matrix of categorical data sequences}

\item{initial}{numerical vector of initial values}

\item{nummethod}{Numerical maximisation method, currently either "NR" (for Newton-Raphson), "BFGS" (for Broyden-Fletcher-Goldfarb-Shanno), "BFGSR" (for the BFGS algorithm implemented in R), "BHHH" (for Berndt-Hall-Hall-Hausman), "SANN" (for Simulated ANNealing), "CG" (for Conjugate Gradients), or "NM" (for Nelder-Mead). Lower-case letters (such as "nr" for Newton-Raphson) are allowed. The default method is "BFGS". For more details see \code{\link[maxLik:maxLik]{maxLik()}}.}
}
\value{
The function returns a list with the parameter estimates, standard-errors, z-statistics, p-values and the value of the log-likelihood function, for each equation.
}
\description{
Estimation of Multivariate Markov Chains through the proposed model by Nicolau (2014).
This model presents two attractive features: it is completely free of constraints, thereby facilitating the estimation procedure,
and it is more precise at estimating the transition probabilities of a multivariate or higher-order Markov chain than the Raftery's MTD model.
}
\examples{
data(stockreturns)
s <- cbind(stockreturns$sp500, stockreturns$djia)
multi.mtd_probit(s, initial = c(1, 1, 1), nummethod = "bfgs")

}
\references{
Nicolau, J. (2014). A new model for multivariate markov chains. Scandinavian Journal of Statistics, 41(4), 1124-1135.\doi{10.1111/sjos.12087}
}
\author{
Carolina Vasconcelos and Bruno Damásio
}
