% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_probability_functions.R
\name{SEsi_left}
\alias{SEsi_left}
\title{Calculate conditional probability of observation at a search}
\usage{
SEsi_left(oi, pk, rng = NULL)
}
\arguments{
\item{oi}{number of searches after arrival}

\item{pk}{numeric array of searcher efficiency p and k parameters
(p = pk[ , 1] and k = pk[ , 2])}

\item{rng}{optional parameter giving the range of intervals to consider}
}
\value{
numeric array of probability of observing a carcass at oi for
  given that it arrived in intervals 1:oi if rng = NULL (or in intervals
  \code{rng}), assuming the carcass had not been previously discovered or
  removed by scavengers
}
\description{
Calculate the conditional probability of observing a carcass 
  at search oi as a function arrival interval (assuming carcass is not
  removed by scavengers before the time of the final search)
}
