% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits_functions.R
\name{calcTsplit}
\alias{calcTsplit}
\title{Estimate the number of fatalities by time interval}
\usage{
calcTsplit(rate, days, tsplit)
}
\arguments{
\item{rate}{Array (nsim x nsearch) of arrival rates as number of fatalities
per search interval. Typically, \code{rate} will be the return value of 
the \code{calcRate} function.}

\item{days}{A vector of times representing search dates when at least one
unit was searched. Times are formatted as number of days since the first
search, e.g., c(0, 7, 14, 28, 35) would indicate a schedule in at least 
one unit was searched every 7 days.}

\item{tsplit}{A vector of times that splits the monitoring period into a
set of time intervals for which \code{calcTsplit} will estimate the 
number of fatalities. For example, if \code{tsplit = c(0, 14, 19, 35)}, 
then \code{calcTsplit} estimates the number of fatalities occuring in 
interval (0, 14], (14, 19], and (19, 35]. Times in \code{tsplit} must be 
increasing and between 0 and max(days), inclusive.}
}
\value{
A numeric array with dimensions
 \code{dim = c(length(tsplit) - 1, nsim)} giving the estimated number of
 fatalities that occured in each time interval.
}
\description{
\code{calcTsplit()} is a lower-level function that requires 
  the output of \code{calcRate} as input. See \code{\link{calcSplits}} 
  for a more powerful, convenient, and flexible alternative.
}
