% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.image.R
\name{text.image}
\alias{text.image}
\title{Generate text using the Generative AI model based on a prompt and an image}
\usage{
text.image(model.parameter, temperature, prompt, image.path)
}
\arguments{
\item{model.parameter}{A character vector containing the Generative AI service provider,
corresponding model, version, API key, and proxy status.}

\item{temperature}{A numeric value. A higher value results in more creative responses,
while a lower value produces more straightforward text.}

\item{prompt}{A character string representing the query for text generation.}

\item{image.path}{A character string representing the path to the image. It should be a link
starting with \code{https}.}
}
\value{
If successful, a character string generated by the Generative AI model based on
the provided query and parameters. If the API response indicates an error, the function
halts execution and provides an error message.
}
\description{
This function establishes a connection to a Generative AI model by providing essential
parameters and generates text based on the prompt and the image.
}
\details{
Providing accurate and valid information for each parameter is crucial
to ensure successful text generation by the Generative AI model. If any of the
provided parameters is incorrect, the function will respond with an error message based
on the information received from the API. Use the function \code{available.models} to
see all supported Generative AI models.
}
\examples{
\dontrun{
 # Get available models
 models = available.models()

 # Connect to the model, replace API_KEY with your api key
 google.model = connect.genai("google",
                              models$google$model[1],
                              models$google$version[1],
                              "API_KEY",
                              FALSE)

 # Connect to the model, replace API_KEY with your api key
 openai.model = connect.genai("openai",
                              models$openai$model[1],
                              models$openai$version[1],
                              "API_KEY",
                              FALSE)
 # Generate text
 temperature = 0.9
 prompt = "Please describe the following image in 50 words."
 image.path = "https://h5n1.gd.edu.kg/images/abstract1.jpg"
 image.description = text.image(google.model,
                                temperature,
                                prompt,
                                image.path)
 cat(image.description)
 image.description = text.image(openai.model,
                                temperature,
                                prompt,
                                image.path)
 cat(image.description)
}

}
