% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynlib.R
\docType{data}
\name{CrystalData}
\alias{CrystalData}
\alias{CrystalData10k}
\alias{CrystalData300k}
\title{Crystallographic Scattering Data}
\format{
A \code{data.frame} with 1721 observations and 2 variables:
\itemize{
  \item{\code{Q} (\eqn{\text{Å}^{-1}})}: The scattering vector, measured in inverse angstroms (\eqn{\text{Å}^{-1}}).
  \item{\code{FQ} (a.u.)}: The measured function \eqn{F(Q)}, given in arbitrary units (a.u.).
}
}
\source{
Data collected from a particle accelerator experiment.
}
\usage{
data(CrystalData10k)

data(CrystalData300k)
}
\description{
This dataset contains crystallographic measurements obtained from a particle 
accelerator experiment. The measurements correspond to the function \eqn{F(Q)} 
at various \eqn{Q} values, which are used to analyze the scattering properties 
of an unknown crystalline material. The dataset is available in two versions 
based on the precision of the measurements:

- **`CrystalData10k`** (lower precision);
- **`CrystalData300k`** (higher precision).

The goal of the experiment is to estimate \eqn{F(Q)} from noisy data using 
a GeDS model and compute its Fourier transform, which provides valuable insights 
into the structure of the material.
}
\examples{
\dontrun{
# Load the dataset (choose 10k or 300k version)
data('CrystalData10k')

# Fit a GeDS/GeDSboost model and compare how well the intensity peaks are captured
Gmod <- NGeDS(FQ ~ f(Q), data = CrystalData10k, phi = 0.999, q = 3)
Gmodboost <- NGeDSboost(FQ ~ f(Q), data = CrystalData10k, phi = 0.999, q = 3)

par(mfrow = c(1,2))
plot(Gmod, n = 2)
plot(Gmodboost, n = 2)

}

}
