% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussSuppressDec.R
\name{GaussSuppressDec}
\alias{GaussSuppressDec}
\title{Cell suppression with synthetic decimal numbers}
\usage{
GaussSuppressDec(
  data,
  ...,
  fun = GaussSuppressionFromData,
  output = NULL,
  use_freqVar = NA,
  digits = 9,
  nRep = NULL,
  rmse = pi/3,
  sparseLimit = 500,
  rndSeed = 123,
  runIpf = FALSE,
  eps = 0.01,
  iter = 100,
  mismatchWarning = TRUE,
  whenDuplicatedInner = NULL,
  whenMixedDuplicatedInner = warning
)
}
\arguments{
\item{data}{Input daata as a data frame}

\item{...}{Further parameters to \code{\link{GaussSuppressionFromData}}}

\item{fun}{A function: \code{\link{GaussSuppressionFromData}} or one of its wrappers such as
\code{\link{SuppressSmallCounts}} and \code{\link{SuppressDominantCells}}.}

\item{output}{NULL (default), \code{"publish"}, \code{"inner"}, \code{"publish_inner"}, or \code{"publish_inner_x"} (x also).}

\item{use_freqVar}{Logical (\code{TRUE}/\code{FALSE}) with a default value of \code{NA}. Determines whether the variable
\code{freqVar} is used as the basis for generating decimal numbers.
If \code{NA}, the parameter is set to \code{TRUE}, except in the following cases, where it is set to \code{FALSE}:
\itemize{
\item If \code{freqVar} is not available.
\item If \code{runIpf} is \code{FALSE} and \code{fun} is one of the functions \code{SuppressFewContributors} or \code{SuppressDominantCells}.
}

When \code{use_freqVar} is \code{FALSE}, only zeros are used instead. This approach is more robust in practice,
as decimal numbers can then be stored more accurately.
The default value is chosen to ensure compatibility with existing code and to allow for the use of \code{freqVar}
when dealing with frequency tables, which may be useful.}

\item{digits}{Parameter to \code{\link[SSBtools]{RoundWhole}}. Values close to whole numbers will be rounded.}

\item{nRep}{NULL or an integer. When >1, several decimal numbers will be generated.}

\item{rmse}{Desired root mean square error of decimal numbers.
Variability around the expected, according to the linear model, inner frequencies.
The expected frequencies are calculated from the non-suppressed publishable frequencies.}

\item{sparseLimit}{Limit for the number of rows of a reduced x-matrix within the algorithm. When exceeded, a new sparse algorithm is used.}

\item{rndSeed}{If non-NULL, a random generator seed to be used locally within the function without affecting the random value stream in R.}

\item{runIpf}{When TRUE, additional frequencies are generated by iterative proportional fitting using \code{\link[SSBtools]{Mipf}}.}

\item{eps}{Parameter to \code{\link[SSBtools]{Mipf}}.}

\item{iter}{Parameter to \code{\link[SSBtools]{Mipf}}.}

\item{mismatchWarning}{Whether to produce the warning "\verb{Mismatch between whole numbers and suppression}", when relevant.
When \code{nRep>1}, all replicates must satisfy the whole number requirement for non-suppressed cells.
When \code{mismatchWarning} is integer (\verb{>0}), this will be used as parameter \code{digits} to \code{\link[SSBtools]{RoundWhole}}
when doing mismatch checking (can be quite low when \code{nRep>1}).}

\item{whenDuplicatedInner}{Function to be called when default output and when cells marked as inner correspond to
several input cells (aggregated) since they correspond to published cells.}

\item{whenMixedDuplicatedInner}{Function to be called in the case above when some inner cells correspond
to published cells (aggregated) and some not (not aggregated).}
}
\value{
A data frame where inner cells and cells to be published are combined or output according to parameter \code{output}.
}
\description{
\code{\link{GaussSuppressionFromData}}, or one of its wrappers, is run and decimal numbers are added to output by
executing  \code{\link[RegSDC]{SuppressDec}}.
}
\examples{
a <- GaussSuppressDec(data = SSBtoolsData("example1"), 
                      fun = SuppressSmallCounts, 
                      dimVar = c("age", "geo"),
                      preAggregate = TRUE, 
                      freqVar = "freq", maxN = 3)
a                       
                 

b <- GaussSuppressDec(data = SSBtoolsData("magnitude1"), 
                      fun = SuppressDominantCells, 
                      numVar = "value", 
                      formula = ~sector2 * geo + sector4 * eu,
                      contributorVar = "company", k = c(80, 99))
b  
 
# FormulaSelection() works on this output as well 
FormulaSelection(b, ~sector2 * geo)                       
                      
}
\seealso{
\code{\link[=SuppressionFromDecimals]{SuppressionFromDecimals()}}
}
\author{
Øyvind Langrsud
}
