% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{arma_mult_cube_vec}
\alias{arma_mult_cube_vec}
\title{Cube multiply over first dimension}
\usage{
arma_mult_cube_vec(cub, v)
}
\arguments{
\item{cub}{A cube (3D array)}

\item{v}{A vector}
}
\value{
Transpose of multiplication over first dimension of cub time v
}
\description{
The result is transposed since that is what apply will give you
}
\examples{
d1 <- 10
d2 <- 1e2
d3 <- 2e2
aa <- array(data = rnorm(d1*d2*d3), dim = c(d1, d2, d3))
bb <- rnorm(d3)
t1 <- apply(aa, 1, function(U) {U\%*\%bb})
t2 <- arma_mult_cube_vec(aa, bb)
dd <- t1 - t2

summary(dd)
image(dd)
table(dd)
# microbenchmark::microbenchmark(apply(aa, 1, function(U) {U\%*\%bb}),
#                                arma_mult_cube_vec(aa, bb))
}
