% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkm.R
\name{gpkm}
\alias{gpkm}
\title{Gaussian process regression model}
\usage{
gpkm(
  X,
  Z,
  kernel,
  trend,
  verbose = 0,
  useC = TRUE,
  useGrad = TRUE,
  parallel = FALSE,
  parallel_cores = "detect",
  nug = 1e-06,
  nug.min = 1e-08,
  nug.max = 100,
  nug.est = TRUE,
  param.est = TRUE,
  restarts = 0,
  normalize = FALSE,
  optimizer = "L-BFGS-B",
  track_optim = FALSE,
  formula,
  data,
  ...
)
}
\arguments{
\item{X}{Matrix whose rows are the input points}

\item{Z}{Output points corresponding to X}

\item{kernel}{The kernel to use. E.g., Gaussian$new().}

\item{trend}{Trend to use. E.g., trend_constant$new().}

\item{verbose}{Amount of stuff to print. 0 is little, 2 is a lot.}

\item{useC}{Should C code be used when possible? Should be faster.}

\item{useGrad}{Should the gradient be used?}

\item{parallel}{Should code be run in parallel? Make optimization
faster but uses more computer resources.}

\item{parallel_cores}{When using parallel, how many cores should
be used?}

\item{nug}{Value for the nugget. The starting value if estimating it.}

\item{nug.min}{Minimum allowable value for the nugget.}

\item{nug.max}{Maximum allowable value for the nugget.}

\item{nug.est}{Should the nugget be estimated?}

\item{param.est}{Should the kernel parameters be estimated?}

\item{restarts}{How many optimization restarts should be used when
estimating parameters?}

\item{normalize}{Should the data be normalized?}

\item{optimizer}{What algorithm should be used to optimize the
parameters.}

\item{track_optim}{Should it track the parameters evaluated
while optimizing?}

\item{formula}{Formula for the data if giving in a data frame.}

\item{data}{Data frame of data. Use in conjunction with formula.}

\item{...}{Not used}
}
\description{
Fits a Gaussian process regression model to data.

An R6 object is returned with many methods.

`gpkm()` is an alias for `GauPro_kernel_model$new()`.
For full documentation, see documentation for `GauPro_kernel_model`.

Standard methods that work include `plot()`, `summary()`, and `predict()`.
}
\details{
The default kernel is a Matern 5/2 kernel, but factor/character inputs
will be given factor kernels.
}
