% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui_functions.R
\name{mergeStates}
\alias{mergeStates}
\title{mergeStates}
\usage{
mergeStates(cohort, statesGroups)
}
\arguments{
\item{cohort}{a \code{cohort} simulated by \code{simulateCohort()}}

\item{statesGroups}{a \code{list of lists} of states to be merged.
e.g. \code{list(list(1,2,3),list(5,6))}}
}
\value{
list(cohortGroup, hfNames)
\code{cohortGroup} is an object with a structure like a \code{cohort} simulated by \code{simulateCohort}. States names
are now concatentations of the names of the states which were merged. Times of transitions 
(cohortGroup (at) time.to.state) are recomputed for groups of merged states. The other attributes of the cohorts
 stay unchanged. 
\code{hfNames} is a \code{matrix} with row names beeing concatenated names of the states that were merged, the values in the matrix are 
"impossible", if the transition between given groups of states is impossible, or "possible", if there is some possible transition between 
the states in the given two groups of states.
}
\description{
Merges the states given by the user. 
The names of merged states are concatenations of names of the states being merged.
\code{merged_cohort\@ time.to.state} is defined as time, when the patient arrives 
in the first state which was merged into the new state.
The function creates also a \code{hfNames} \code{matrix} for the merged states. They are used only to plot a graph of possible 
transmissions between merged states.
}
\examples{

hfNames <- array(rep("Exponential", 16), dim = c(4,4))
hfNames[col(hfNames) <= row(hfNames)]<-"NULL"
rownames(hfNames) <- as.list(paste("state", 1:4))
colnames(hfNames) <- as.list(paste("state", 1:4))
M <- makeM(hfNames)
param <- generateParameterMatrix(M)
param[[1,2]] <- list(rate = 1)
param[[1,3]] <- list(rate = 2)
param[[2,3]] <- list(rate = 0.5)

param[[1,4]] <- list(rate = 1)
param[[2,4]] <- list(rate = 2)
param[[3,4]] <- list(rate = 0.5)

cohort <- simulateCohort(
transitionFunctions = M,
parameters = param,
cohortSize = 100,
to=10)
 
tmp <- mergeStates(cohort, statesGroup = list(list(1,2), list(3,4)))
merged_cohort <- tmp[["cohort"]]
merged_hfNames <- tmp[["hfNames"]]

}
\seealso{
simulateCohort
}
\keyword{merge}
\keyword{mergeStates,}
