% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{nzLog10.old}
\alias{nzLog10.old}
\title{nzLog10.old}
\usage{
nzLog10.old(x, quiet = FALSE)
}
\arguments{
\item{x}{A numerical vector containing non-negative values.}

\item{quiet}{A boolean that tells the script to suppress warning messages. (This does not suppress errors, however.)}
}
\value{
A vector containing transformed values.
}
\description{
Utility function to safely (non-zero) log10 transform p-values that are bounded at 0, and may be zero or
may be rounded to zero in certain contexts. To get around this, prior to applying a log10 transformation the function
adds a very small pseudocount to all the values if any are detected to be zero. This avoids the generation of negative
infinities. (See details, below.)
}
\details{
Prior to log10 transformation, this function first scans for any zeros in the input vector. If it
finds any, it warns that zeros have been detected in the raw statistic, and that a pseudocount will be added.
To do this the function assesses the precision of the numbers in the numerical vector by counting decimal
places and determining the minimal non-zero number represented in the vector. It then takes whichever is the
lesser of those numbers and adds a pseudocount equal to the lesser of 1/2 the precision, or 1/2 the lowest
non-zero number.
}
\examples{

p_vals <- c( 0.5, 0.001, 0.00001, 5e-19, 6.24e-23, 0 )
nzLog10( p_vals )

}
