% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsnDistanceHistogram.R
\name{gsnDistanceHistogram}
\alias{gsnDistanceHistogram}
\title{gsnDistanceHistogram}
\usage{
gsnDistanceHistogram(
  object,
  distance = NULL,
  dist.matrix = c("raw", "pared", "edges"),
  stat = "percent",
  colors = NULL,
  bins = 100
)
}
\arguments{
\item{object}{A GSNData object}

\item{distance}{A distance, or even a character vector of distances, e.g. c("lf", "jaccard", "stlf").}

\item{dist.matrix}{The names of distance matrices, which can be "raw" for the distance stored in "matrix",
"pared" for the distances stored in "pared", and "edges" for the distances stored in "edges". In general,
the distances in "edges" will be the same as those in "pared", but this may not always be true.}

\item{stat}{Can be "percent", "count", "density", or "cumulative". This determines how the data are visualized.}

\item{colors}{Currently, this does nothing, but will eventually allow the user to specify custom colors. Stay
tuned.}

\item{bins}{The number of bins, for histograms ("percent" or "count").}
}
\value{
A ggplot2 graphical object.
}
\description{
Generate a Histogram of Distances
}
\details{
This function is useful for such purposes as assessing the effects of paring on the distribution of
distances.
}
\seealso{
\code{\link{plot.GSNData}}
\code{\link{gsnPlotNetwork}}
\code{\link{gsnHierarchicalDendrogram}}
}
