% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{gsn_default_distance}
\alias{gsn_default_distance}
\alias{gsn_default_distance<-}
\alias{gsn_distances}
\alias{pw_id_col}
\alias{pw_id_col<-}
\alias{pw_stat_col}
\alias{pw_stat_col<-}
\alias{pw_stat_col_2}
\alias{pw_stat_col_2<-}
\alias{pw_sig_order}
\alias{pw_sig_order<-}
\alias{pw_sig_order_2}
\alias{pw_sig_order_2<-}
\alias{pw_n_col}
\alias{pw_n_col<-}
\alias{pw_type}
\alias{pw_type<-}
\title{gsn_default_distance, gsn_distances, pw_id_col, pw_stat_col, pw_sig_order, pw_stat_col_2, pw_sig_order_2, pw_n_col, pw_type}
\usage{
gsn_default_distance(object)

gsn_default_distance(object) <- value

gsn_distances(object)

pw_id_col(object)

pw_id_col(object) <- value

pw_stat_col(object)

pw_stat_col(object) <- value

pw_stat_col_2(object)

pw_stat_col_2(object) <- value

pw_sig_order(object)

pw_sig_order(object) <- value

pw_sig_order_2(object)

pw_sig_order_2(object) <- value

pw_n_col(object)

pw_n_col(object) <- value

pw_type(object)

pw_type(object) <- value
}
\arguments{
\item{object}{A GSNData object.}

\item{value}{A valid value for the field to be set. (see \emph{Details}.).}
}
\value{
For get versions of the functions, evaluated alone or on the right side of a \code{<-}
assignment, the values stored in the relevant fields are returned, generally as character vectors
of length 1 (or NULL), except for gsn_distances which may return character vectors of varying length.
For set versions of the functions, for which the function call is on the left side of a \code{<-}
assignment, a copy of the \code{GSNData} object with the specified field set is returned. See
\emph{Details}.)
}
\description{
Get and set values for GSNData internal fields. When evaluated directly or on
the right side of an \code{<-} assignment, these functions retrieve stored values. When
evaluated on the left side of a \code{<-} assignment, they set the relevant field values.
}
\details{
\describe{
\item{\strong{gsn_default_distance()}}{Gets and sets the value stored in the \code{obect$default_distance}
field of a \code{GSNData} object. When a \code{GSNData} object contains distance matrices of
multiple types (e.g. single-tail log fisher & Jaccard, the \code{defailt_distance} field tells
\code{GSNA} which distance to use for network paring, subnet assignment, plotting, etc.
When setting the value, it must be a character vector of length 1 that contains the name of
a valid distance metric for which there exists a distance matrix in the GSNData object, or
else an error will be raised.}
\item{\strong{gsn_distances()}}{Returns a character vector containing the names of the distances for which
there are distance matrices in a \code{GSNData} object.}
\item{\strong{pw_id_col()}}{Gets and sets the value stored in the \code{obect$pathways$id_col} field. This
is the field that determines which column in a pathways data.frame corresponds to a gene set
identifier used in a gene set collection list of vectors, or a \code{tmod} or \code{tmodGS}
object. When setting the value, this the function checks that the value is a valid column in
\code{obect$pathways$data}.}
\item{\strong{pw_stat_col()}}{Gets and sets the value stored in the \code{obect$pathways$stat_col} field.
This is the field that determines which column in a pathways data.frame corresponds to a
significance statistic of interest. When setting the value, this the function checks that the
value is a valid column in \code{obect$pathways$data}.}
\item{\strong{pw_sig_order()}}{Gets and sets the value stored in the \code{obect$pathways$sig_order} field.
This is the field that states the behavior of the significance value in the
\code{obect$pathways$sig_order} field, specifically whether low or high values are significant.
This may be either \code{'loToHi'} or \code{'hiToLo'}. (Other types of statistics are possible,
for example statistics with significant of high or low \emph{absolute} values. We hope to add
support for such statistics in the future.)}
\item{\strong{pw_stat_col_2()}}{Gets and sets the value stored in the \code{obect$pathways$stat_col_2} field.
For two-channel GSNA analysis, this is the field that determines which column in a pathways
data.frame corresponds to the second significance statistic of interest. When setting the value,
this the function checks that the value is a valid column in \code{obect$pathways$data}.}
\item{\strong{pw_sig_order_2()}}{Gets and sets the value stored in the \code{obect$pathways$sig_order_2} field.
For a two-channel GSNA analysis, this is the field that states the behavior of the significance
value in the \code{obect$pathways$sig_order_2} field, specifically whether low or high values
are significant. This may be either \code{'loToHi'} or \code{'hiToLo'}. (Other types of
statistics are possible, for example statistics with significant of high or low \emph{absolute}
values. We hope to add support for such statistics in the future.)}
\item{\strong{pw_n_col()}}{Gets and sets the value stored in the \code{obect$pathways$n_col} field.
This is the field that determines which column in a pathways data.frame corresponds to a
gene set size or gene set effective size. When setting the value, this the function checks
that the value is a valid column in \code{obect$pathways$data}.}
\item{\strong{pw_type()}}{Gets and sets the value stored in the \code{obect$pathways$type} field.
This is the field that describes what kind of pathways data are stored in the object,
e.g. \code{'gsea'} or \code{'cerno'}. If there is no current pathways data in the object
an error will be raised.}
}
}
\examples{
# These examples require some setup.
#
# First, we will generate a gene set network from CERNO example
# data, containing multiple distance metrics, as well as pathways
# data. We begin by subsetting the CERNO data for significant results:
sig_pathways.cerno <- subset( Bai_CiHep_DN.cerno, adj.P.Val <= 0.05 )

# Now create a gene set collection containing just the gene sets
# with significant CERNO results, by subsetting Bai_gsc.tmod using
# the gene set IDs as keys:
sig_pathways.tmod <- Bai_gsc.tmod[sig_pathways.cerno$ID]

# And obtain a background gene set from differential expression data:
background_genes <- toupper( rownames( Bai_CiHep_v_Fib2.de ) )

# Create a GSNData object containing Jaccard indices:
sig_pathways.GSN <-
   buildGeneSetNetworkJaccard(geneSetCollection = sig_pathways.tmod,
                              ref.background = background_genes )

# Within the same object, add an 'stlf' (Single Tail Log Fisher)
# distance matrix:
sig_pathways.GSN <-
   buildGeneSetNetworkSTLF( object = sig_pathways.GSN )

# Now import the CERNO data:
sig_pathways.GSN <- gsnAddPathwaysData( sig_pathways.GSN,
                                        pathways_data = sig_pathways.cerno )

# Use gsn_distances() to see what distances are stored in the
# GSNData object:
gsn_distances( sig_pathways.GSN )
# Should return: "jaccard" "stlf"

# See what the default distance is:
gsn_default_distance( sig_pathways.GSN )
# Returns: "stlf". Let's change the default distannce
# to "jaccard":
gsn_default_distance( sig_pathways.GSN ) <- "jaccard"

# Let's examine what the ID column is:
pw_id_col( sig_pathways.GSN )
# Returns: "ID"
pw_id_col( sig_pathways.GSN ) <- "ID"
# This is equivalent to the following code. When
# invoked on the left side of an assignment, R uses
# *syntactic sugar* to comvert the call to:
sig_pathways.GSN <- `pw_id_col<-`( object = sig_pathways.GSN,
                                   value = "ID" )

# On the other hand, the following returns an error
# because there is no column in the pathways dataframe
# named "invalid.name":
 class( try( pw_id_col( sig_pathways.GSN ) <- "invalid.name" ) )
 # "try-error"



# Likewise we can get and set the value of stat_col
# and sig_order:
pw_stat_col(sig_pathways.GSN )
# Returns "adj.P.Val". Let's set it to "AUC"
pw_stat_col(sig_pathways.GSN) <- "AUC"
# And likewise, sig_order:
pw_sig_order(sig_pathways.GSN) # "loToHi"
pw_sig_order(sig_pathways.GSN) <- "hiToLo"


# For 2-channel GSNA analyses, we can set the values
# of stat_col_2 and sig_order_2:
pw_stat_col_2(sig_pathways.GSN )
# Returns NULL. Let's set it to "P.Value"
pw_stat_col_2(sig_pathways.GSN) <- "P.Value"
# And likewise, sig_order:
pw_sig_order_2(sig_pathways.GSN) # NULL
pw_sig_order(sig_pathways.GSN) <- "loToHi"

# pw_n_col() works the same way to set n_col:
pw_n_col(sig_pathways.GSN) # "N1"
pw_n_col(sig_pathways.GSN) <- "N1"

# And also, pw_type()
pw_type(sig_pathways.GSN) # "cerno"
# For setting via pw_type, the value is not
# currently checked, since pathways data may
# be of many types:
pw_type(sig_pathways.GSN) <- "other"

pw_type(sig_pathways.GSN) # "other"


}
