% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cano2M.R
\name{cano2M}
\alias{cano2M}
\title{canoToM : Converts canonical formulation into matricial formulation}
\usage{
cano2M(nVar, dMax, poly)
}
\arguments{
\item{nVar}{The model dimension expected. This parameter will be
deduced from the input data (\code{series}) if \code{series} is
a matrix. If \code{series} is a vector, the expected dimension nVar
should be provided.}

\item{dMax}{Maximum degree of the polynomial functions allowed
in the model (see \code{poLabs}).}

\item{poly}{A vector of coefficients corresponding to the regressor
of the canonical function}
}
\description{
Converts the vectorial formulation of canonical models
into a matricial formulation. For both input, the list of terms 
follows the convention given in `poLabs`.
}
\examples{
polyTerms <- c(0.2,0,-1,0.5,0,0,0,0,0,0)
K <- cano2M(3,2,polyTerms)
visuEq(3,2,K)

}
\author{
Sylvain Mangiarotti, Mireille Huc
}

