% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotSymDevFun.R
\name{plotSymDevFun}
\alias{plotSymDevFun}
\title{Display the Symmetric Deviation Function}
\usage{
plotSymDevFun(CPF, n.grid = 100)
}
\arguments{
\item{CPF}{CPF object, see \code{\link[GPareto]{CPF}},}

\item{n.grid}{number of divisions of the grid in each dimension.}
}
\description{
Display the Symmetric Deviation Function for an object of class CPF.
}
\details{
Display observations in red and the corresponding Pareto front by a step-line.
The blue line is the estimation of the location of the Pareto front of the kriging models, named Vorob'ev expectation.
In grayscale is the intensity of the deviation (symmetrical difference) from the Vorob'ev expectation for couples of conditional simulations.
}
\examples{
library(DiceDesign)
set.seed(42)

nvar <- 2

# Test function
fname = "P1"

# Initial design
nappr <- 10
design.grid <- maximinESE_LHS(lhsDesign(nappr, nvar, seed = 42)$design)$design
response.grid <- t(apply(design.grid, 1, fname))

ParetoFront <- t(nondominated_points(t(response.grid)))

# kriging models : matern5_2 covariance structure, linear trend, no nugget effect
mf1 <- km(~., design = design.grid, response = response.grid[, 1])
mf2 <- km(~., design = design.grid, response = response.grid[, 2])

# Conditional simulations generation with random sampling points
nsim <- 10 # increase for better results
npointssim <- 80 # increase for better results
Simu_f1 = matrix(0, nrow = nsim, ncol = npointssim)
Simu_f2 = matrix(0, nrow = nsim, ncol = npointssim)
design.sim = array(0,dim = c(npointssim, nvar, nsim))

for(i in 1:nsim){
  design.sim[,, i] <- matrix(runif(nvar*npointssim), npointssim, nvar)
  Simu_f1[i,] = simulate(mf1, nsim = 1, newdata = design.sim[,, i], cond = TRUE,
                         checkNames = FALSE, nugget.sim = 10^-8)
  Simu_f2[i,] = simulate(mf2, nsim = 1, newdata = design.sim[,, i], cond=TRUE,
                         checkNames = FALSE, nugget.sim = 10^-8)
}

# Attainment, Voreb'ev expectation and deviation estimation
CPF1 <- CPF(Simu_f1, Simu_f2, response.grid, ParetoFront)

# Symmetric deviation function
plotSymDevFun(CPF1)
}
\references{
M. Binois, D. Ginsbourger and O. Roustant (2015), Quantifying Uncertainty on Pareto Fronts with Gaussian process conditional simulations,
\emph{European Journal of Operational Research}, 243(2), 386-394. \cr \cr
}

