% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mean_sd_nn.R
\name{estimate_mean_sd_nn}
\alias{estimate_mean_sd_nn}
\title{Estimate the CERF with the nnGP model}
\usage{
estimate_mean_sd_nn(
  hyperparam,
  sigma2,
  w_obs,
  w,
  y_obs,
  gps_m,
  kernel_fn = function(x) exp(-x^2),
  n_neighbor = 50,
  block_size = 2000,
  nthread = 1
)
}
\arguments{
\item{hyperparam}{A set of hyperparameters for the nnGP.}

\item{sigma2}{A scaler representing \code{sigma^2}.}

\item{w_obs}{A vector of observed exposure levels.}

\item{w}{A vector of exposure levels at which the CERF is estimated.}

\item{y_obs}{A vector of observed outcome values.}

\item{gps_m}{An S3 gps object including:
gps: A data.frame of GPS vectors.
- Column 1: GPS
- Column 2: Prediction of exposure for covariate of each data sample
(e_gps_pred).
- Column 3: Standard deviation of  e_gps (e_gps_std)
used_params:
- dnorm_log: TRUE or FLASE}

\item{kernel_fn}{The covariance function of the GP.}

\item{n_neighbor}{The number of nearest neighbors on one side.}

\item{block_size}{The number of samples included in a computation block.
Mainly used to balance the speed and memory requirement. Larger
\code{block_size} is faster, but requires more memory.}

\item{nthread}{An integer value that represents the number of threads to be
used by internal packages.}
}
\value{
A vector of returned value from \code{compute_posterior_sd_nn}.
}
\description{
Estimates the posterior mean of the conditional exposure response function
at specified exposure levels with nnGP.
}
\keyword{internal}
