% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{distance}
\alias{distance}
\title{Compute distances for two sets of inputs}
\usage{
distance(input1, input2, type = "isotropic", dtype = "Euclidean")
}
\arguments{
\item{input1}{a matrix of inputs}

\item{input2}{a matrix of inputs}

\item{type}{a string indicating the form of distances with three froms supported currently: \strong{isotropic}, \strong{tensor}, \strong{ARD}.}

\item{dtype}{a string indicating distance type: \strong{Euclidean}, \strong{GCD}, where the latter indicates great circle distance.}
}
\value{
a R object holding distances for two sets of inputs. If \strong{type} is \strong{isotropic}, a matrix of distances
is returned; if \strong{type} is \strong{tensor} or \strong{ARD}, a list of distance matrices 
along each input dimension is returned.

a numeric vector or matrix of distances
}
\description{
This function computes distances for two sets of inputs and returns
a \code{R} object.
}
\examples{
input = seq(0,1,length=20)
d = distance(input, input, type="isotropic", dtype="Euclidean")

}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
