% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JumpNode.R
\name{Level2JumpNodeBP}
\alias{Level2JumpNodeBP}
\title{Jump nodes from a GO BP level}
\usage{
Level2JumpNodeBP(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{Organism of interest that is supported by the package}
}
\value{
All jump nodes from the level
}
\description{
The function retrieves the Jump nodes (JNs) from a GO-level. JNs are those GO-terms which have at least
              one child term not present in the level below it. If the optional parameter "organism" is missing then
              the results are from the general GO tree. The supported organisms are "Homo sapiens / Human",
             "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# Jump nodes from level 3
Level2JumpNodeBP(level = 3, organism = "Homo sapiens")

# Jump nodes from level 6
Level2JumpNodeBP(level = 6, organism = "Arabidopsis thaliana")

}
