% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgotree.R
\name{GetDAG}
\alias{GetDAG}
\title{Organism-specific GO-DAG edgelist}
\usage{
GetDAG(organism, domain = "BP")
}
\arguments{
\item{organism}{An object of class character that represents the organism. If the organism option is
"BP", "MF" or "CC" the biological process, molecular function and cellular component general GO edgelist
are obtained respectively}

\item{domain}{The ontology of the GO-terms. The default is BP.}
}
\value{
A two-column matrix of the nodes and the edges to which they are connected
}
\description{
Derive the organism gene association GO-terms as an edgelist. It indicates how the terms are linked together.
             The supported organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse",
             "Danio rerio / Zebrafish","Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast", "Drosophila melanogaster / Fruit fly", " Escherichia coli / E.coli"
}
\examples{
# Edgelist for entire GO BP ontology
\donttest{
GetDAG(organism = "BP")

# Edgelist for cellular component gene association GO-terms for organism Yeast
GetDAG(organism = "Yeast", domain = "CC")

# Edgelist for molecular function gene association GO-terms for organism Zebrafish
GetDAG(organism = "Zebrafish", domain = "MF")
}
}
