% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.ts.ng.int.req.df.r
\name{return.ts.ng.int.req.df}
\alias{return.ts.ng.int.req.df}
\title{Return two-sample normal-gamma predictive probability}
\usage{
return.ts.ng.int.req.df(
  mu.0.t = 0,
  n.0.t = 1e-04,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  mu.0.c = 0,
  n.0.c = 1e-04,
  alpha.0.c = 0.25,
  beta.0.c = 1,
  xbar.t = c(1.9, 2, 2.1, 2.05),
  s.t = c(2, 2.1, 1.9, 2.04),
  n.t = c(10, 20, 30, 40),
  xbar.c = c(1, 1.1, 1.5, 1.25),
  s.c = c(1.9, 2, 2.5, 2.25),
  n.c = c(10, 20, 30, 40),
  Delta.lrv = 1.25,
  Delta.tv = 1.75,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  xbar_ng = NULL,
  xbar_go = NULL,
  go.thresh = 0.8,
  ng.thresh = 0.8,
  n.MC = 1000
)
}
\arguments{
\item{mu.0.t}{prior mean for treatment group}

\item{n.0.t}{prior effective sample size parameter for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{mu.0.c}{prior mean for control group}

\item{n.0.c}{prior effective sample size parameter for control group}

\item{alpha.0.c}{prior alpha parameter for control group}

\item{beta.0.c}{prior beta parameter for control group}

\item{xbar.t}{treatment mean}

\item{s.t}{treatment sd}

\item{n.t}{treatment sample size}

\item{xbar.c}{control mean}

\item{s.c}{control sd}

\item{n.c}{control sample size}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{xbar_ng}{Leave NULL to determine what is required or supply a value}

\item{xbar_go}{Leave NULL to determine what is required or supply a value}

\item{go.thresh}{If the predictive probability that study will conclude as 'Go' is larger than this threshold: Declare 'Interim go'.}

\item{ng.thresh}{If the predictive probability that study will conclude as 'No-Go' is larger than this threshold: Declare 'Interim no-go'}

\item{n.MC}{Monte Carlo simulation size}
}
\value{
A dataframe is returned
}
\description{
Return two-sample normal-gamma predictive probability
}
\examples{
holdit <- return.ts.ng.int.req.df()
head(holdit)
}
