% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.ss.ng.ppp.r
\name{make.ss.ng.ppp}
\alias{make.ss.ng.ppp}
\title{Make singple sample normal-gamma prior posterior plot}
\usage{
make.ss.ng.ppp(
  mu.0.t = 0,
  n.0.t = 1,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  xbar.t = 1.75,
  s.t = 2,
  n.t = 50,
  gamma.IG.sd.limits = c(as.numeric(trimws(unlist(strsplit("5, 25, 25", ",")))))
)
}
\arguments{
\item{mu.0.t}{prior mean}

\item{n.0.t}{prior effective sample size}

\item{alpha.0.t}{prior alpha parameter}

\item{beta.0.t}{prior beta parameter}

\item{xbar.t}{sample mean for treatment group}

\item{s.t}{sample sd for treatment group}

\item{n.t}{sample size for treatment group}

\item{gamma.IG.sd.limits}{limits used for Precision, Variance and standard deviation visualizers}

\item{limits}{upper limits used for visualizations}
}
\value{
A ggplot object is returned
}
\description{
Make singple sample normal-gamma prior posterior plot
}
\examples{
my.ss.ng.ppp <- make.ss.ng.ppp()
my.ss.ng.ppp[[1]][[1]]
my.ss.ng.ppp[[1]][[2]]
gridExtra::grid.arrange(my.ss.ng.ppp[[1]][[1]], my.ss.ng.ppp[[1]][[2]], ncol=2)
my.ss.ng.ppp[[2]]
my.ss.ng.ppp[[3]]
my.ss.ng.ppp[[4]]
my.ss.ng.ppp[[5]]
my.ss.ng.ppp[[6]]
my.ss.ng.ppp[[7]]
}
