% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.tte.studyend.GNG.r
\name{get.tte.studyend.GNG}
\alias{get.tte.studyend.GNG}
\title{Get TTE studyend GNG decision}
\usage{
get.tte.studyend.GNG(
  m.con.prior = 50,
  m.trt.prior = 50,
  HR.prior = 1.2,
  ARatio = 1,
  HR.obs = 1.3,
  m.obs = 200,
  HR.tv = 1.4,
  HR.lrv = 1.25,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65
)
}
\arguments{
\item{m.con.prior}{number of prior events for control}

\item{m.trt.prior}{number of prior events for treatment}

\item{HR.prior}{HR estimate}

\item{ARatio}{randomization ratio}

\item{HR.obs}{Observed HR}

\item{m.obs}{observed events}

\item{HR.tv}{Base TPP for HR}

\item{HR.lrv}{Min TPP for HR}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}
}
\value{
a list is returned holding what is needed from data to achieve Go/No-Go
}
\description{
Get TTE studyend GNG decision
}
\examples{
my.tte.studyend.GNG <- get.tte.studyend.GNG(m.con.prior = 50,m.trt.prior = 50, HR.prior=1.2,
ARatio=1, HR.obs=1.3, m.obs = 200, HR.tv= 1.4, HR.lrv = 1.25, tau.tv=.1, tau.lrv=.8, tau.ng=.65)
my.tte.studyend.GNG
}
