% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.bin.dec.df.r
\name{get.ts.bin.dec.df}
\alias{get.ts.bin.dec.df}
\title{Get Two-sample binary decision data.frame}
\usage{
get.ts.bin.dec.df(
  a.con = 1,
  b.con = 1,
  n.con = 40,
  x.con = 0:40,
  a.trt = 1,
  b.trt = 1,
  n.trt = 40,
  x.trt = 0:40,
  Delta.tv = 0.25,
  Delta.lrv = 0.2,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65
)
}
\arguments{
\item{a.con}{prior alpha parameter for control group}

\item{b.con}{prior beta parameter for control group}

\item{n.con}{sample size for control}

\item{x.con}{responders on control}

\item{a.trt}{prior alpha parameter for treatment group}

\item{b.trt}{prior beta parameter for treatment group}

\item{n.trt}{sample size for treatment}

\item{x.trt}{responders for treatment}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}
}
\value{
a dataframe is returned
}
\description{
Get Two-sample binary decision data.frame
}
\examples{
holdit <- get.ts.bin.dec.df()
head(holdit)
}
