\name{css}
\alias{css}
\alias{css.hclust}
\title{Clustering Sum-of-Squares for clustering evaluation}
\usage{
  css(dist.obj,clusters)

  ## Computing Sum-of-Squares given Hierarchical Clustering
    css.hclust(dist.obj, hclust.obj=NULL,hclust.FUN=hclust,
    hclust.FUN.MoreArgs=list(method="ward"),k=NULL)
}
\arguments{
  \item{dist.obj}{a `dist' object as produced by
  \code{dist} or \code{gdist}.}

  \item{clusters}{a vector with cluster memberships.}

  \item{k}{numeric, the upper bound of the number of
  clusters to compute. DEFAULT: \emph{20} or the number of
  observations (if less than \emph{20}).}

  \item{hclust.obj}{a `hclust' object, generated by
  \emph{\code{hclust}}}

  \item{hclust.FUN}{a function, to generate a hierarchical
  clustering. Ignored with \code{hclust.obj} specified.
  DEFAULT: \emph{\code{hclust}}}

  \item{hclust.FUN.MoreArgs}{a list, containing arguments
  that are passed to \code{hclust.FUN}.}
}
\value{
  \code{css} returns a `css' object, which is a list
  containing the following components \tabular{ll}{ k \tab
  number of clusters\cr wss\tab \emph{\code{k}}
  within-cluster sum-of-squares \cr totwss\tab total
  within-cluster sum-of-square\cr totbss\tab total
  between-cluster sum-of-square\cr tss\tab total sum of
  squares of the data\cr } , and with an attribute `meta'
  that contains the input components \tabular{ll}{ dist.obj
  \tab (the input) distance matrix\cr clusters \tab (the
  input) cluster membership\cr }

  \code{css.hclust} returns a `css.multi' object, which is
  a data.frame containing the following columns
  \tabular{ll}{ k \tab number of clusters\cr ev \tab
  explained variance given \emph{\code{k}}\cr totbss \tab
  total between-cluster sum-of-square\cr tss \tab total sum
  of squares of the data\cr } , and with an attribute
  `meta' that contains \tabular{ll}{ cmethod \tab the
  clustering method\cr dist.obj \tab (the input) distance
  matrix\cr k \tab (the input) number of clusters\cr
  clusters \tab the `hclust' object that is either by input
  or computed by default\cr }
}
\description{
  Evaluation on the varaince of a clustering model using
  squared Euclidean distances, based on distance matrix and
  cluster membership.
}
\details{
  Clustering Sum-of-Squares for clustering evaluation.
}
\seealso{
  \code{\link{elbow}} for "elbow" plot using `css.multi'
  object
}

