% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtable.R
\name{ggtable}
\alias{ggtable}
\title{Cross-tabulated tables of discrete variables}
\usage{
ggtable(
  data,
  columnsX = 1:ncol(data),
  columnsY = 1:ncol(data),
  cells = c("observed", "prop", "row.prop", "col.prop", "expected", "residuals",
    "stdres"),
  fill = c("none", "stdres", "residuals"),
  mapping = NULL,
  ...
)
}
\arguments{
\item{data}{dataset to be used, can have both categorical and
numerical variables}

\item{columnsX, columnsY}{names or positions of which columns are used to make plots. Defaults to all columns.}

\item{cells}{Which statistic should be displayed in table cells?}

\item{fill}{Which statistic should be used for filling table cells?}

\item{mapping}{additional aesthetic to be used, for example to indicate
weights (see examples)}

\item{...}{additional arguments passed to \code{\link{ggduo}} (see examples)}
}
\description{
\code{ggtable} is a variant of \code{\link{ggduo}} for quick
cross-tabulated tables of discrete variables.
}
\examples{
# small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

if (require(Hmisc)) {
  data(tips, package = "reshape")
  p_(ggtable(tips, "smoker", c("day", "time", "sex")))

  # displaying row proportions
  p_(ggtable(tips, "smoker", c("day", "time", "sex"), cells = "row.prop"))

  # filling cells with standardized residuals
  p_(ggtable(tips, "smoker", c("day", "time", "sex"), fill = "stdres", legend = 1))

  # if continuous variables are provided, just displaying some summary statistics
  p_(ggtable(tips, c("smoker", "total_bill"), c("day", "time", "sex", "tip")))

  # specifying weights
  d <- as.data.frame(Titanic)
  p_(ggtable(
    d,
    "Survived",
    c("Class", "Sex", "Age"),
    mapping = aes(weight = Freq),
    cells = "row.prop",
    fill = "stdres"
  ))
}
}
\author{
Joseph Larmarange
}
