% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmatrix.R
\name{ggmatrix}
\alias{ggmatrix}
\title{ggpairs - A ggplot2 Matrix}
\usage{
ggmatrix(plots, nrow, ncol, xAxisLabels = NULL, yAxisLabels = NULL,
  title = NULL, byrow = TRUE, showStrips = NULL,
  showAxisPlotLabels = TRUE, showXAxisPlotLabels = TRUE,
  showYAxisPlotLabels = TRUE, verbose = FALSE, data = NULL, gg = NULL,
  legends = FALSE)
}
\arguments{
\item{plots}{list of plots to be put into matrix}

\item{nrow, ncol}{number of rows and columns}

\item{xAxisLabels, yAxisLabels, title}{labels for plot. Set the variable to \code{NULL} to not be displayed}

\item{byrow}{boolean that determines whether the plots should be ordered by row or by column}

\item{showStrips}{boolean to determine if each plot's strips should be displayed. \code{NULL} will default to the top and right side plots only. \code{TRUE} or \code{FALSE} will turn all strips on or off respectively.}

\item{showAxisPlotLabels, showXAxisPlotLabels, showYAxisPlotLabels}{booleans that determine if the plots axis labels are printed on the X (bottom) or Y (left) part of the plot matrix. If \code{showAxisPlotLabels} is set, both \code{showXAxisPlotLabels} and \code{showYAxisPlotLabels} will be set to the given value.}

\item{verbose}{boolean to determine the printing of "Plot #1, Plot #2...."}

\item{data}{data set using. This is the data to be used in place of 'ggally_data' if the plot is a string to be evaluated at print time}

\item{gg}{ggplot2 theme objects to be applied to every plot}

\item{legends}{boolean to determine the printing of the legend in each plot. Not recommended.}
}
\description{
Make a generic matrix of ggplot2 plots
}
\examples{
plotList <- list()
for (i in 1:6) {
  plotList[[i]] <- ggally_text(paste("Plot #", i, sep = ""))
}
a <- ggmatrix(
  plotList,
  2, 3,
  c("A", "B", "C"),
  c("D", "E"),
  byrow = TRUE
)
#a

a <- ggmatrix(
  plotList,
  2, 3,
  xAxisLabels = c("A", "B", "C"),
  yAxisLabels = NULL,
  byrow = FALSE,
  showXAxisPlotLabels = FALSE
)
#a
}
\author{
Barret Schloerke \email{schloerke@gmail.com}
}
\keyword{hplot}

