% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGEPlot.R
\name{GGEPlot}
\alias{GGEPlot}
\title{GGE biplots with \pkg{ggplot2}}
\usage{
GGEPlot(
  GGEModel,
  type = 1,
  d1 = 1,
  d2 = 2,
  selectedE = NA,
  selectedG = NA,
  selectedG1 = NA,
  selectedG2 = NA,
  colSegment = "red",
  colHull = "black",
  largeSize = 4.5,
  axis_expand = 1.2,
  axislabels = TRUE,
  axes = TRUE,
  limits = TRUE,
  titles = TRUE,
  footnote = TRUE,
  textGen = element_text(family = "", face = 1, color = "forestgreen", size = 4, hjust
    = 0, vjust = 0, angle = 0),
  textEnv = element_text(family = "", face = 1, color = "blue", size = 4, hjust = 0,
    vjust = 0, angle = 0)
)
}
\arguments{
\item{GGEModel}{An object of class \code{GGEModel} or \code{gge}}

\item{type}{type of biplot to produce. \enumerate{\item Basic biplot. \item
Examine environment. See \code{\link[GGEBiplots]{ExamineEnv}} \item Examine
genotype. See \code{\link[GGEBiplots]{ExamineGen}} \item Relationship among
environments. See \code{\link[GGEBiplots]{EnvRelationship}} \item Compare
two genotypes. See \code{\link[GGEBiplots]{CompareGens}} \item Which won
where/what. See \code{\link[GGEBiplots]{WhichWon}} \item Discrimination vs.
representativeness. See \code{\link[GGEBiplots]{DiscRep}} \item Ranking
environments. See \code{\link[GGEBiplots]{RankEnv}} \item Mean vs.
stability. See \code{\link[GGEBiplots]{MeanStability}} \item Ranking
gentoypes See \code{\link[GGEBiplots]{RankGen}}}}

\item{d1}{PCA component to plot on x axis. Defaults to 1}

\item{d2}{PCA component to plot on y axis. Defaults to 2}

\item{selectedE}{name of the environment to examine when type=2. Must be a
string which matches an environment label}

\item{selectedG}{name of the genotype to examine when type=3. Must be a string
which matches a genotype label}

\item{selectedG1}{name of a genotype to compare when type=5. Must be a string
which matches a genotype label}

\item{selectedG2}{name of a genotype to compare when type=5. Must be a string
which matches a genotype label and not equal to selectedG1}

\item{colSegment}{colour for segment or circle lines. Defaults to "red"}

\item{colHull}{colour for hull when type=6. Defaults to "black"}

\item{largeSize}{text size to use for larger labels where type=5, used for the
two selected genotypes, and where type=6, used for the outermost genotypes.
Defaults to 4.5}

\item{axis_expand}{multiplication factor to expand the axis limits by to
enable fitting of labels. Defaults to 1.2}

\item{axislabels}{logical. If TRUE then include automatically generated labels
for axes}

\item{axes}{logical. If TRUE then include x and y axes going through the
origin}

\item{limits}{logical. If TRUE then automatically rescale axes}

\item{titles}{logical. If TRUE then include automatically generated titles}

\item{footnote}{logical. If TRUE then include automatically generated footnote}

\item{textGen}{element_text for genotype labels}

\item{textEnv}{element_text for environment labels}
}
\value{
A biplot of class \code{ggplot}
}
\description{
Produces the GGE biplot as an object of class 'ggplot' from a model produced
by a call to either \code{\link[GGEBiplots]{GGEModel}} or
\code{\link[gge]{gge}}. Nearly all stylistic attributes of output can either
be customised within the function or disabled so that the user can customise
output to their own liking.
}
\examples{
data(Ontario)
GGE1<-GGEModel(Ontario)
GGEPlot(GGE1)


}
\references{
Yan W, Kang M (2003). \emph{GGE Biplot Analysis: A Graphical Tool
 for Breeders, Geneticists, and Agronomists}. CRC Press.
}
\keyword{Biplot}
\keyword{GGE}
