% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve-set.r
\name{curve_set}
\alias{curve_set}
\alias{create_curve_set}
\title{Create a curve_set object}
\usage{
curve_set(
  obs,
  sim = NULL,
  r = NULL,
  theo = NULL,
  allfinite = FALSE,
  verbose = TRUE
)

create_curve_set(curve_set, allfinite = FALSE, verbose = TRUE)
}
\arguments{
\item{obs}{The observed data. See details.}

\item{sim}{The simulated data. See details.}

\item{r}{The argument values where the functions/vectors have been observed (or simulated). See details.}

\item{theo}{The theoretical function. See details.}

\item{allfinite}{Logical. TRUE requires that all values of the curves must be
finite (not infinite and not missing, see \code{\link{is.finite}}). FALSE
allows for infinite or missing values in the curves. These infinite and missing
values can have consequences for the subsequent analyses. A warning is given
if infinite or missing values exists (when \code{verbose = TRUE}).}

\item{verbose}{Logical flag indicating whether to warn about the content.}

\item{curve_set}{A list containing the element obs, and optionally
the elements r, sim_m (same as sim, but in matrix format only) and theo.
See details.}
}
\value{
An object of class \code{curve_set} containing the data.
If the argument values are two-dimensional, then the \code{curve_set} is additionally
a \code{curve_set2d} object.
}
\description{
Create a curve_set object out of data provided in the right form.
}
\details{
The functions are used to clump together the functional data in the form
that can be handled by the other \pkg{GET} functions (\code{\link{forder}},
\code{\link{central_region}}, \code{\link{global_envelope_test}} etc.).
The functions take care of checking the content of the data,
and save relevant information of the curves for global envelope
methods to be used in particular for plotting the results with graphical
interpretation.

\code{obs} must be either
\itemize{
\item a vector containing the data function/vector, or
\item a matrix containing the s data functions/vectors, in which case it is assumed that
each column corresponds to a data function/vector, or
\item a list containing the s data functions/vectors.
}

If \code{obs} is a vector, \code{sim} must be either
\itemize{
\item a matrix containing the simulated functions/vectors, each column
corresponding to a function/vector and the number of rows matching the length
of \code{obs}, or
\item a list containing the simulated functions/vectors.
}
If \code{obs} is a matrix or a list, \code{sim} is ignored.

If given, \code{r} describes the 1- or 2-dimensional argument values where the functions/vectors
have been observed (or simulated). It must be either
\itemize{
\item a vector,
\item a data.frame with columns "x", "y", "width" and "height",
where the width and height give the width and height of the pixels placed at x and y, or
\item a data.frame with columns "xmin", "xmax", "ymin" and "ymax" giving the corner
coordinates of the pixels where the data have been observed.
}

If \code{obs} is a vector, \code{theo} can be given and it should then correspond
to a theoretical function (e.g., under the null hypothesis). If present, its
length must match the length of \code{obs}.
}
\examples{
# 1d
cset <- curve_set(r = 1:10, obs = matrix(runif(10*5), ncol=5))
plot(cset)
# 2d
cset <- curve_set(r = data.frame(x=c(rep(1:3, 3), 4), y=c(rep(1:3, each=3), 1),
                                 width=1, height=1),
                  obs = matrix(runif(10*5), ncol=5))
plot(cset)
}
\seealso{
\code{\link{plot.curve_set}}, \code{\link{plot.curve_set2d}}
}
