% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGENEAsegments.R
\name{getGENEAsegments}
\alias{getGENEAsegments}
\title{import and segment one or more bin files.}
\usage{
getGENEAsegments(testfile, start = NULL, end = NULL,
  Use.Timestamps = FALSE, outputtoken = "_segmented",
  outputdir = "GENEAclassification", datacols = "default",
  decimalplaces = "default", filterWave = FALSE, filtername = "haar",
  j = 8, changepoint = c("UpDownDegrees", "TempFreq", "UpDownFreq"),
  penalty = "Manual", pen.value = 10, intervalseconds = 30,
  mininterval = 5, peaks = TRUE, AxesMethod = c("X", "Y", "Z", "XZ", "XY",
  "YZ", "XYZ"), ma.smooth = TRUE, Peak_Threshold = 10,
  Central_Threshold = 0.2, Step_Threshold = 0.5,
  stepmethod = c("Chebyfilter", "Butterfilter", "longrun", "none"),
  boundaries = c(0.15, 1), samplefreq = 100, smlen = 100L,
  threshold = 0.001, filterorder = 4L, Rp = 0.5, plot.it = FALSE,
  plot.seg = FALSE, plot.seg.outputfile = "Changepoint", Centre = TRUE,
  STFT = FALSE, win = 10, verbose = FALSE, ...)
}
\arguments{
\item{testfile}{character vector stating path to a GENEActiv bin file, or a folder containing GENEActiv bin files.}

\item{start}{Where to start reading observations.}

\item{end}{Where to end reading observations.}

\item{Use.Timestamps}{To use timestamps as the start and end time values this has to be set to TRUE. (Default FALSE)}

\item{outputtoken}{single character string to be appended to the file name
for saving the segmenation output (default '_segmentated').}

\item{outputdir}{The absolute or relative path to directory in which artifacts (plot and changes files) should be created, or NULL
(default "GENEAclassification").}

\item{datacols}{a vector constructed 'column.summary' or 'default'. See \code{\link{segmentation}} for details.}

\item{decimalplaces}{named numeric vector of decimal places with which to
round summary columns. \code{NULL} returns unrounded values.
The length 1 character vector 'default' applies default roundings: \itemize{
    \item Start.Time = 0,
    \item Degrees.mean = 3,
    \item Degrees.median = 3,
    \item Degrees.var = 3,
    \item Degrees.sd = 3,
    \item Degrees.mad = 3,
    \item Magnitude.mean = 3,
    \item UpDown.mean = 3,
    \item UpDown.median = 3,
    \item UpDown.var = 3
    \item UpDown.sd = 3,
    \item UpDown.mad = 3,
    \item Principal.Frequency.median = 3,
    \item Principal.Frequency.mad = 3,
    \item Principal.Frequency.ratio = 3,
    \item Principal.Frequency.sumdiff = 3,
    \item Principal.Frequency.meandiff = 3,
    \item Principal.Frequency.abssumdiff = 3,
    \item Principal.Frequency.sddiff = 3,
    \item Light.mean = 0,
    \item Light.max = 0,
    \item Temp.mean = 1,
    \item Temp.sumdiff = 3
    \item Temp.meandiff = 3
    \item Temp.abssumdiff = 3
    \item Temp.sddiff = 3
    \item Step.count = 0
    \item Step.sd = 1
    \item Step.mean = 0
}
This can be changed by using a named list. e.g decimalplaces = c(Start.Time = 2, Degrees.mean = 4).}

\item{filterWave}{single logical, should a smoothing filter from \code{\link[waveslim]{wave.filter}} be applied? (default FALSE).}

\item{filtername}{single character, the name of the wavelet to use for smoothing
when filter is TRUE. (default "haar") Passed to \code{link[waveslim]{wave.filter}}.}

\item{j}{single numeric, the level to which to smooth. Passed to \code{link[waveslim]{wave.filter}} (default 8).}

\item{changepoint}{defines the change point analysis to use. UpDownDegrees performs the change point analysis on the variance of arm elevation and wrist rotation. 
TempFreq performs a change point on the variance in the temeprature and frequency (Typically better for sleep behaviours).}

\item{penalty}{single characgter, the penalty to use for changepoint detection. default ("SIC").}

\item{pen.value}{Value of the type 1 error required when penalty is "Asymptotic".}

\item{intervalseconds}{An integer number of seconds between 5 and 30 during which at most one changepoint may occur.}

\item{mininterval}{single numeric that defines the smallest changepoint initially found. Passed to \code{\link[changepoint]{cpt.var}} as the variable minseglen}

\item{peaks}{single logical to indicate which step counter to use. If TRUE \code{\link[GENEAclassify]{stepCounter2}} will be used,
if FALSE \code{\link[GENEAclassify]{stepCounter}} will be used. (default TRUE).}

\item{AxesMethod}{Select which axes to count the steps. \enumerate{
    \item 'X'
    \item 'Y' (default)
    \item 'Z'
    \item 'XY'
    \item 'XZ'
    \item 'YZ'
    \item 'XYZ'
}}

\item{ma.smooth}{Should a moving average filter be applied to the data.}

\item{Peak_Threshold}{Number of values either side of the peak/valley that are higher/lower for the value to qualify as a peak/valley}

\item{Central_Threshold}{After the signal has been centred around 0}

\item{Step_Threshold}{The difference between a peak, valley then peak or valley, peak then valley to constitute a step.}

\item{stepmethod}{defines the method used by the step counting algoirthm, see \code{\link[GENEAclassify]{stepCounter}} for details.}

\item{boundaries}{to pass to the filter in the step counting algorithm.}

\item{samplefreq}{The sampling frequency of the data, in hertz,
when calculating the step number. (default 100).}

\item{smlen}{defines the window length used within the step counting alogirthm.}

\item{threshold}{Threshold for the step counter to register a step.}

\item{filterorder}{The order of the filter applied with respect to the butter or cheby options. 
See \code{\link[signal]{cheby1}} or \code{\link[signal]{butter}}.}

\item{Rp}{the decibel level that the cheby filter takes. See \code{\link[signal]{cheby1}}.}

\item{plot.it}{single logical, Creates a plot showing the zero crossings counted by the step counting algorithm#' @param Centre Centres the xz signal about 0 when set to True.}

\item{plot.seg}{single logical, Creates a plot displaying the changepoint locations.}

\item{plot.seg.outputfile}{The name of the png file created that shows the change points on a positionals plots.}

\item{Centre}{single logical, Centres the xz signal about 0 (default TRUE) when counting the zero crossings within the step counting algorithm.}

\item{STFT}{If STFT is TRUE then the Step Counter uses the STFT function to find the length of the window for each segment.}

\item{win}{The window length at which to compute the STFT for the changepoint analysis. See \code{\link[GENEAread]{stft}}.}

\item{verbose}{single logical should additional progress reporting be printed at the console? (default TRUE).}

\item{...}{other arguments to be passed to \code{\link{dataImport}},
\code{\link{segmentation}} and other functions with these functions.}
}
\value{
segmented data are returned
}
\description{
Import and summarize GENEActiv bin data for manual classification.
}
\examples{
## segData <- getGENEAsegments(
##     testfile = "subj02_left_wrist_2013-01-03_17-21-06_Being_Driven3.bin",
##     outputdir = file.path(tempdir(), "GENEAclassification"),
##    filter = TRUE, j = 5)
## head(segData)
## list.files(file.path(tempdir(), "GENEAclassification"))
}
\seealso{
The returned object can be interrogated with \code{\link[=head.GENEAbin]{head}}.
}
