#' @export
#' @title An Example Illustrating the Sticky-Decision Path and Business Cycles
#' @aliases gemStickyDecisionPath_2_2
#' @description This is an 2-by-2 example that illustrates the sticky-decision path and business cycles.
#' Assume that the consumer has a linear utility function x1 + 0.8 * x2.
#' @param ... arguments to be passed to the function sdm2.
#' @examples
#' \donttest{
#' stickiness <- 0.1 # 0.5
#' ge <- sdm2(
#'   A = function(state) {
#'     a.firm <- CD_A(alpha = 2, Beta = c(0.5, 0.5), state$p)
#'     if (1.25 * state$p[2] < state$p[1]) {
#'       a.consumer <- c(0, 1)
#'     } else {
#'       a.consumer <- c(1, 0)
#'     }
#'
#'     a.consumer <- state$last.A[, 2] * stickiness + a.consumer * (1 - stickiness)
#'     cbind(a.firm, a.consumer)
#'   },
#'   B = matrix(c(
#'     1, 0,
#'     0, 0
#'   ), 2, 2, TRUE),
#'   S0Exg = matrix(c(
#'     NA, NA,
#'     NA, 100
#'   ), 2, 2, TRUE),
#'   names.commodity = c("prod", "lab"),
#'   names.agent = c("firm", "laborer"),
#'   numeraire = "prod",
#'   z0 = c(80, 100),
#'   maxIteration = 1,
#'   numberOfPeriods = 100,
#'   ts = TRUE
#' )
#'
#' matplot(ge$ts.z, type = "o", pch = 20)
#' }

gemStickyDecisionPath_2_2 <- function(...) sdm2(...)
