#' @export
#' @title An Endogenous Production Function
#' @aliases gemstEndogenousProductionFunction
#' @description This is an example of the market-clearing path with an endogenous production function.
#' The parameter of the production function will change with the output level.
#' @param ... arguments to be passed to the function sdm2.
#' @examples
#' \donttest{
#' dst.firm <- node_new(
#'   "output",
#'   type = "CD", alpha = 5, beta = c(0.5, 0.5),
#'   "prod", "lab"
#' )
#'
#' dst.consumer <- node_new(
#'   "util",
#'   type = "Leontief", a = 1,
#'   "prod"
#' )
#'
#' ge <- sdm2(
#'   A = list(dst.firm, dst.consumer),
#'   B = matrix(c(
#'     1, 0,
#'     0, 1
#'   ), 2, 2, TRUE),
#'   S0Exg = matrix(c(
#'     NA, NA,
#'     NA, 1
#'   ), 2, 2, TRUE),
#'   names.commodity = c("prod", "lab"),
#'   names.agent = c("firm", "consumer"),
#'   numeraire = "lab",
#'   z0 = c(1, 1),
#'   p0 = c(1, 1),
#'   ts = TRUE,
#'   policy = list(
#'     function(A, state) {
#'       A[[1]]$alpha <- 5 * state$last.z[1]^0.1
#'     },
#'     policyMarketClearingPrice
#'   ),
#'   numberOfPeriods = 40,
#'   maxIteration = 1
#' )
#'
#' matplot(ge$ts.z, type = "b", pch = 20)
#' }
#'

gemstEndogenousProductionFunction <- function(...) sdm2(...)
