% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dantzigS.R
\name{dantzigS}
\alias{dantzigS}
\title{Dantzig selector using the lpsolve package}
\source{
Cand{\`e}s, E. and Tao, T. (2007). The Dantzig selector: Statistical estimation when p is much
larger than n. Annals of Statistics 35 (6), 2313--2351.

Phoa, F. K., Pan, Y. H. and Xu, H. (2009). Analysis of supersaturated
designs via the Dantzig selector. Journal of Statistical Planning and Inference
139 (7), 2362--2372.
}
\usage{
dantzigS(X, y, delta, scale.X = 1)
}
\arguments{
\item{X}{a design matrix.}

\item{y}{a vector of  responses.}

\item{delta}{the specific value of \code{delta} for which the Dantzig Selector
optimization needs to be solved}

\item{scale.X}{a number by which each column of \code{X} should be scaled}
}
\value{
A list containing the (a) \code{opt} (Value of objective function
at optimum), (b) \code{status} (Numeric indicator: 0 = success,
2 = no feasible solution), (c) \code{beta} (the estimated values
of \code{beta}), (d) \code{delta}
}
\description{
The Dantzig selector (DS) finds a solution for the model parameters
of a linear model, \code{beta} using linear programming. For a given \code{delta},
DS minimizes the l1-norm (sum of absolute values) of \code{beta} subject to the constraint
that \code{max(t(X)(y-X * beta))}<= \code{delta}.
}
\keyword{internal}
