% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdm.R
\name{gdm}
\alias{gdm}
\alias{print.gdm}
\alias{plot.gdm}
\title{Optimal discretization and geographical detectors for multiple variables and visulization}
\usage{
gdm(y, xcategorical=NULL, xcontinuous=NULL, discmethod, discitv)
\\method{print}{gdm}(result)
\\method{plot}{gdm}(result)
}
\arguments{
\item{y}{A numeric vector of response variable}

\item{xcategorical}{A vector or a data.frame of categorical variables}

\item{xcontinuous}{A vector or a data.frame of continuous variables}

\item{discmethod}{A character vector of discretization methods}

\item{discitv}{A numeric vector of numbers of intervals}

\item{result}{A list of \code{gdm} result}
}
\description{
Optimal discretization and geographical detectors for multiple variables and visulization
}
\examples{
###############
## NDVI: ndvi_40
###############
## define elements orders of categorical variables
cz <- c("Bwk","Bsk","Dwa","Dwb","Dwc") ## climate zone
mp <- c("very low","low","medium","high","very high") ## mining production
ndvi_40$Climatezone <- as.numeric(1:5)[match(ndvi_40$Climatezone, cz)]
ndvi_40$Mining <- as.numeric(1:5)[match(ndvi_40$Mining, mp)]
## set optional parameters of optimal discretization
## optional methods: equal, natural, quantile, geometric, sd and manual
discmethod <- c("equal","natural","quantile")
discitv <- c(4:6)
## "gdm" function
ndvigdm <- gdm(y = ndvi_40[,1], xcategorical = ndvi_40[,2:3],
               xcontinuous = ndvi_40[,4:7],
               discmethod = discmethod, discitv = discitv)
# ndvigdm
# plot(ndvigdm)
#############
## H1N1: h1n1_100
#############
### set optional parameters of optimal discretization
# discmethod <- c("equal","natural","quantile")
# discitv <- c(4:6)
### "gdm" function
# h1n1gdm <- gdm(y = h1n1_100[,1], xcategorical = h1n1_100[,11],
#               xcontinuous = h1n1_100[,c(2:10)],
#               discmethod = discmethod, discitv = discitv)
# h1n1gdm
# plot(h1n1gdm)

}
